/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.util;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.apache.ApacheHttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import java.io.IOException;
import java.net.Authenticator;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.base.Strings;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.GoogleLogger;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.impl.client.DefaultHttpClient;

public class HttpTransportFactory {
    private static final GoogleLogger logger = GoogleLogger.forEnclosingClass();
    public static final HttpTransportType DEFAULT_TRANSPORT_TYPE = HttpTransportType.JAVA_NET;

    @Deprecated
    public static HttpTransportType getTransportTypeOf(@Nullable String typeName) {
        HttpTransportType type = DEFAULT_TRANSPORT_TYPE;
        if (!Strings.isNullOrEmpty(typeName)) {
            try {
                type = HttpTransportType.valueOf(typeName);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Invalid HttpTransport type '%s'. Must be one of %s.", typeName, Arrays.toString((Object[])HttpTransportType.values())), e);
            }
        }
        return type;
    }

    public static HttpTransport createHttpTransport(HttpTransportType type, @Nullable String proxyAddress) throws IOException {
        return HttpTransportFactory.createHttpTransport(type, proxyAddress, null, null);
    }

    public static HttpTransport createHttpTransport(HttpTransportType type, @Nullable String proxyAddress, @Nullable String proxyUsername, @Nullable String proxyPassword) throws IOException {
        ((GoogleLogger.Api)logger.atFine()).log("createHttpTransport(%s, %s, %s, %s)", (Object)type, proxyAddress, HttpTransportFactory.toSecretString(proxyUsername), HttpTransportFactory.toSecretString(proxyPassword));
        Preconditions.checkArgument(proxyAddress != null || proxyUsername == null && proxyPassword == null, "if proxyAddress is null then proxyUsername and proxyPassword should be null too");
        Preconditions.checkArgument(proxyUsername == null == (proxyPassword == null), "both proxyUsername and proxyPassword should be null or not null together");
        URI proxyUri = HttpTransportFactory.parseProxyAddress(proxyAddress);
        try {
            switch (type) {
                case APACHE: {
                    UsernamePasswordCredentials proxyCredentials = proxyUsername != null ? new UsernamePasswordCredentials(proxyUsername, proxyPassword) : null;
                    return HttpTransportFactory.createApacheHttpTransport(proxyUri, proxyCredentials);
                }
                case JAVA_NET: {
                    PasswordAuthentication proxyAuth = proxyUsername != null ? new PasswordAuthentication(proxyUsername, proxyPassword.toCharArray()) : null;
                    return HttpTransportFactory.createNetHttpTransport(proxyUri, proxyAuth);
                }
            }
            throw new IllegalArgumentException(String.format("Invalid HttpTransport type '%s'", type.name()));
        }
        catch (GeneralSecurityException e) {
            throw new IOException(e);
        }
    }

    static String toSecretString(@Nullable String secret) {
        return secret == null ? "<not provided>" : "<provided, but not displayed>";
    }

    @Deprecated
    public static ApacheHttpTransport createApacheHttpTransport(@Nullable HttpHost proxy) throws IOException, GeneralSecurityException {
        return HttpTransportFactory.createApacheHttpTransport(proxy == null ? null : URI.create(proxy.toURI()), null);
    }

    public static ApacheHttpTransport createApacheHttpTransport(@Nullable URI proxyUri, @Nullable Credentials proxyCredentials) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument(proxyUri != null || proxyCredentials == null, "if proxyUri is null than proxyCredentials should be null too");
        ApacheHttpTransport transport = new ApacheHttpTransport.Builder().trustCertificates(GoogleUtils.getCertificateTrustStore()).setProxy(proxyUri == null ? null : new HttpHost(proxyUri.getHost(), proxyUri.getPort())).build();
        if (proxyCredentials != null) {
            ((DefaultHttpClient)transport.getHttpClient()).getCredentialsProvider().setCredentials(new AuthScope(proxyUri.getHost(), proxyUri.getPort()), proxyCredentials);
        }
        return transport;
    }

    @Deprecated
    public static NetHttpTransport createNetHttpTransport(@Nullable Proxy proxy) throws IOException, GeneralSecurityException {
        return HttpTransportFactory.createNetHttpTransport(proxy == null ? null : HttpTransportFactory.parseProxyAddress(proxy.address().toString()), null);
    }

    public static NetHttpTransport createNetHttpTransport(final @Nullable URI proxyUri, final @Nullable PasswordAuthentication proxyAuth) throws IOException, GeneralSecurityException {
        Preconditions.checkArgument(proxyUri != null || proxyAuth == null, "if proxyUri is null than proxyAuth should be null too");
        if (proxyAuth != null) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    if (this.getRequestorType() == Authenticator.RequestorType.PROXY && this.getRequestingHost().equalsIgnoreCase(proxyUri.getHost()) && this.getRequestingPort() == proxyUri.getPort()) {
                        return proxyAuth;
                    }
                    return null;
                }
            });
        }
        return new NetHttpTransport.Builder().trustCertificates(GoogleUtils.getCertificateTrustStore()).setProxy(proxyUri == null ? null : new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyUri.getHost(), proxyUri.getPort()))).build();
    }

    public static HttpTransport newTrustedTransport() throws GeneralSecurityException, IOException {
        return HttpTransportFactory.createNetHttpTransport(null, null);
    }

    @VisibleForTesting
    static URI parseProxyAddress(@Nullable String proxyAddress) {
        if (Strings.isNullOrEmpty(proxyAddress)) {
            return null;
        }
        String uriString = (proxyAddress.contains("//") ? "" : "//") + proxyAddress;
        try {
            URI uri = new URI(uriString);
            String scheme = uri.getScheme();
            String host = uri.getHost();
            int port = uri.getPort();
            Preconditions.checkArgument(Strings.isNullOrEmpty(scheme) || scheme.matches("https?"), "HTTP proxy address '%s' has invalid scheme '%s'.", (Object)proxyAddress, (Object)scheme);
            Preconditions.checkArgument(!Strings.isNullOrEmpty(host), "Proxy address '%s' has no host.", (Object)proxyAddress);
            Preconditions.checkArgument(port != -1, "Proxy address '%s' has no port.", (Object)proxyAddress);
            Preconditions.checkArgument(uri.equals(new URI(scheme, null, host, port, null, null, null)), "Invalid proxy address '%s'.", (Object)proxyAddress);
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Invalid proxy address '%s'.", proxyAddress), e);
        }
    }

    public static enum HttpTransportType {
        APACHE,
        JAVA_NET;

    }
}

