/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness;

import java.io.IOException;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.beam.fn.harness.PTransformRunnerFactory;
import org.apache.beam.fn.harness.control.BundleSplitListener;
import org.apache.beam.fn.harness.data.BeamFnDataClient;
import org.apache.beam.fn.harness.data.PCollectionConsumerRegistry;
import org.apache.beam.fn.harness.data.PTransformFunctionRegistry;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.fn.harness.state.SideInputSpec;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PCollectionViewTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.Timer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ListMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Sets;

abstract class DoFnPTransformRunnerFactory<TransformInputT, FnInputT, OutputT, RunnerT extends DoFnPTransformRunner<TransformInputT>>
implements PTransformRunnerFactory<RunnerT> {
    DoFnPTransformRunnerFactory() {
    }

    @Override
    public final RunnerT createRunnerForPTransform(PipelineOptions pipelineOptions, BeamFnDataClient beamFnDataClient, BeamFnStateClient beamFnStateClient, String pTransformId, RunnerApi.PTransform pTransform, Supplier<String> processBundleInstructionId, Map<String, RunnerApi.PCollection> pCollections, Map<String, RunnerApi.Coder> coders, Map<String, RunnerApi.WindowingStrategy> windowingStrategies, PCollectionConsumerRegistry pCollectionConsumerRegistry, PTransformFunctionRegistry startFunctionRegistry, PTransformFunctionRegistry finishFunctionRegistry, BundleSplitListener splitListener) {
        Context context = new Context(pipelineOptions, beamFnStateClient, pTransformId, pTransform, processBundleInstructionId, pCollections, coders, windowingStrategies, pCollectionConsumerRegistry, splitListener);
        Object runner = this.createRunner(context);
        startFunctionRegistry.register(pTransformId, () -> runner.startBundle());
        Sets.SetView<String> mainInput = Sets.difference(pTransform.getInputsMap().keySet(), Sets.union(context.parDoPayload.getSideInputsMap().keySet(), context.parDoPayload.getTimerSpecsMap().keySet()));
        for (String localInputName : mainInput) {
            pCollectionConsumerRegistry.register(pTransform.getInputsOrThrow(localInputName), pTransformId, arg_0 -> runner.processElement(arg_0));
        }
        for (String localName : context.parDoPayload.getTimerSpecsMap().keySet()) {
            TimeDomain timeDomain = DoFnSignatures.getTimerSpecOrThrow(context.doFnSignature.timerDeclarations().get(localName), context.doFn).getTimeDomain();
            pCollectionConsumerRegistry.register(pTransform.getInputsOrThrow(localName), pTransformId, timer -> runner.processTimer(localName, timeDomain, (WindowedValue)timer));
        }
        finishFunctionRegistry.register(pTransformId, () -> runner.finishBundle());
        return runner;
    }

    abstract RunnerT createRunner(Context<FnInputT, OutputT> var1);

    static class Context<InputT, OutputT> {
        final PipelineOptions pipelineOptions;
        final BeamFnStateClient beamFnStateClient;
        final String ptransformId;
        final RunnerApi.PTransform pTransform;
        final Supplier<String> processBundleInstructionId;
        final RehydratedComponents rehydratedComponents;
        final DoFn<InputT, OutputT> doFn;
        final DoFnSignature doFnSignature;
        final TupleTag<OutputT> mainOutputTag;
        final Coder<?> inputCoder;
        final SchemaCoder<InputT> schemaCoder;
        final Coder<?> keyCoder;
        final SchemaCoder<OutputT> mainOutputSchemaCoder;
        final Coder<? extends BoundedWindow> windowCoder;
        final WindowingStrategy<InputT, ?> windowingStrategy;
        final Map<TupleTag<?>, SideInputSpec> tagToSideInputSpecMap;
        Map<TupleTag<?>, Coder<?>> outputCoders;
        final RunnerApi.ParDoPayload parDoPayload;
        final ListMultimap<String, FnDataReceiver<WindowedValue<?>>> localNameToConsumer;
        final BundleSplitListener splitListener;

        Context(PipelineOptions pipelineOptions, BeamFnStateClient beamFnStateClient, String ptransformId, RunnerApi.PTransform pTransform, Supplier<String> processBundleInstructionId, Map<String, RunnerApi.PCollection> pCollections, Map<String, RunnerApi.Coder> coders, Map<String, RunnerApi.WindowingStrategy> windowingStrategies, PCollectionConsumerRegistry pCollectionConsumerRegistry, BundleSplitListener splitListener) {
            this.pipelineOptions = pipelineOptions;
            this.beamFnStateClient = beamFnStateClient;
            this.ptransformId = ptransformId;
            this.pTransform = pTransform;
            this.processBundleInstructionId = processBundleInstructionId;
            ImmutableMap.Builder tagToSideInputSpecMapBuilder = ImmutableMap.builder();
            try {
                this.rehydratedComponents = RehydratedComponents.forComponents(RunnerApi.Components.newBuilder().putAllCoders(coders).putAllPcollections(pCollections).putAllWindowingStrategies(windowingStrategies).build()).withPipeline(Pipeline.create());
                this.parDoPayload = RunnerApi.ParDoPayload.parseFrom(pTransform.getSpec().getPayload());
                this.doFn = ParDoTranslation.getDoFn(this.parDoPayload);
                this.doFnSignature = DoFnSignatures.signatureForDoFn(this.doFn);
                this.mainOutputTag = ParDoTranslation.getMainOutputTag(this.parDoPayload);
                String mainInputTag = Iterables.getOnlyElement(Sets.difference(pTransform.getInputsMap().keySet(), Sets.union(this.parDoPayload.getSideInputsMap().keySet(), this.parDoPayload.getTimerSpecsMap().keySet())));
                RunnerApi.PCollection mainInput = pCollections.get(pTransform.getInputsOrThrow(mainInputTag));
                this.inputCoder = this.rehydratedComponents.getCoder(mainInput.getCoderId());
                this.keyCoder = this.inputCoder instanceof KvCoder || this.inputCoder instanceof WindowedValue.WindowedValueCoder && ((WindowedValue.WindowedValueCoder)this.inputCoder).getValueCoder() instanceof KvCoder ? (this.inputCoder instanceof WindowedValue.WindowedValueCoder ? ((KvCoder)((WindowedValue.WindowedValueCoder)this.inputCoder).getValueCoder()).getKeyCoder() : ((KvCoder)this.inputCoder).getKeyCoder()) : null;
                this.schemaCoder = this.inputCoder instanceof SchemaCoder || this.inputCoder instanceof WindowedValue.WindowedValueCoder && ((WindowedValue.WindowedValueCoder)this.inputCoder).getValueCoder() instanceof SchemaCoder ? (this.inputCoder instanceof WindowedValue.WindowedValueCoder ? (SchemaCoder)((WindowedValue.WindowedValueCoder)this.inputCoder).getValueCoder() : (SchemaCoder)this.inputCoder) : null;
                this.windowingStrategy = this.rehydratedComponents.getWindowingStrategy(mainInput.getWindowingStrategyId());
                this.windowCoder = this.windowingStrategy.getWindowFn().windowCoder();
                this.outputCoders = Maps.newHashMap();
                for (Map.Entry<String, String> entry : pTransform.getOutputsMap().entrySet()) {
                    TupleTag outputTag = new TupleTag(entry.getKey());
                    RunnerApi.PCollection outputPCollection = pCollections.get(entry.getValue());
                    Coder<Object> outputCoder = this.rehydratedComponents.getCoder(outputPCollection.getCoderId());
                    if (outputCoder instanceof WindowedValue.WindowedValueCoder) {
                        outputCoder = ((WindowedValue.WindowedValueCoder)outputCoder).getValueCoder();
                    }
                    this.outputCoders.put(outputTag, outputCoder);
                }
                Coder<?> outputCoder = this.outputCoders.get(this.mainOutputTag);
                this.mainOutputSchemaCoder = outputCoder instanceof SchemaCoder ? (SchemaCoder)outputCoder : null;
                for (Map.Entry<String, RunnerApi.SideInput> entry : this.parDoPayload.getSideInputsMap().entrySet()) {
                    String sideInputTag = entry.getKey();
                    RunnerApi.SideInput sideInput = entry.getValue();
                    Preconditions.checkArgument("urn:beam:sideinput:materialization:multimap:0.1".equals(sideInput.getAccessPattern().getUrn()), "This SDK is only capable of dealing with %s materializations but was asked to handle %s for PCollectionView with tag %s.", (Object)"urn:beam:sideinput:materialization:multimap:0.1", (Object)sideInput.getAccessPattern().getUrn(), (Object)sideInputTag);
                    RunnerApi.PCollection sideInputPCollection = pCollections.get(pTransform.getInputsOrThrow(sideInputTag));
                    WindowingStrategy<?, ?> sideInputWindowingStrategy = this.rehydratedComponents.getWindowingStrategy(sideInputPCollection.getWindowingStrategyId());
                    tagToSideInputSpecMapBuilder.put(new TupleTag(entry.getKey()), SideInputSpec.create(this.rehydratedComponents.getCoder(sideInputPCollection.getCoderId()), sideInputWindowingStrategy.getWindowFn().windowCoder(), PCollectionViewTranslation.viewFnFromProto(entry.getValue().getViewFn()), PCollectionViewTranslation.windowMappingFnFromProto(entry.getValue().getWindowMappingFn())));
                }
            }
            catch (IOException exn) {
                throw new IllegalArgumentException("Malformed ParDoPayload", exn);
            }
            ImmutableListMultimap.Builder localNameToConsumerBuilder = ImmutableListMultimap.builder();
            for (Map.Entry<String, String> entry : pTransform.getOutputsMap().entrySet()) {
                localNameToConsumerBuilder.putAll((Object)entry.getKey(), new FnDataReceiver[]{pCollectionConsumerRegistry.getMultiplexingConsumer(entry.getValue())});
            }
            this.localNameToConsumer = localNameToConsumerBuilder.build();
            this.tagToSideInputSpecMap = tagToSideInputSpecMapBuilder.build();
            this.splitListener = splitListener;
        }
    }

    static interface DoFnPTransformRunner<T> {
        public void startBundle() throws Exception;

        public void processElement(WindowedValue<T> var1) throws Exception;

        public void processTimer(String var1, TimeDomain var2, WindowedValue<KV<Object, Timer>> var3);

        public void finishBundle() throws Exception;
    }
}

