/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.control;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterHandler.class);
    private final ConcurrentMap<String, CompletableFuture<Message>> idToObject = new ConcurrentHashMap<String, CompletableFuture<Message>>();

    public Message getById(String id) {
        try {
            LOG.debug("Attempting to find {}", (Object)id);
            CompletableFuture<Message> returnValue = this.computeIfAbsent(id);
            return returnValue.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException(String.format("Failed to load %s", id), e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(String.format("Failed to load %s", id), e);
        }
    }

    public BeamFnApi.InstructionResponse.Builder register(BeamFnApi.InstructionRequest request) {
        BeamFnApi.InstructionResponse.Builder response = BeamFnApi.InstructionResponse.newBuilder().setRegister(BeamFnApi.RegisterResponse.getDefaultInstance());
        BeamFnApi.RegisterRequest registerRequest = request.getRegister();
        for (BeamFnApi.ProcessBundleDescriptor processBundleDescriptor : registerRequest.getProcessBundleDescriptorList()) {
            LOG.debug("Registering {} with type {}", (Object)processBundleDescriptor.getId(), (Object)processBundleDescriptor.getClass());
            this.computeIfAbsent(processBundleDescriptor.getId()).complete(processBundleDescriptor);
            for (Map.Entry<String, RunnerApi.Coder> entry : processBundleDescriptor.getCodersMap().entrySet()) {
                LOG.debug("Registering {} with type {}", (Object)entry.getKey(), (Object)entry.getValue().getClass());
                this.computeIfAbsent(entry.getKey()).complete(entry.getValue());
            }
        }
        return response;
    }

    private CompletableFuture<Message> computeIfAbsent(String id) {
        return this.idToObject.computeIfAbsent(id, ignored -> new CompletableFuture());
    }
}

