/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.data;

import java.io.Closeable;
import java.util.HashMap;
import org.apache.beam.runners.core.metrics.LabeledMetrics;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.core.metrics.MonitoringInfoMetricName;
import org.apache.beam.runners.core.metrics.SimpleMonitoringInfoBuilder;
import org.apache.beam.sdk.fn.data.FnDataReceiver;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.MetricsContainer;
import org.apache.beam.sdk.metrics.MetricsEnvironment;
import org.apache.beam.sdk.util.WindowedValue;

public class ElementCountFnDataReceiver<T>
implements FnDataReceiver<WindowedValue<T>> {
    private FnDataReceiver<WindowedValue<T>> original;
    private Counter counter;
    private MetricsContainer unboundMetricContainer;

    public ElementCountFnDataReceiver(FnDataReceiver<WindowedValue<T>> original, String pCollection, MetricsContainerStepMap metricContainerRegistry) {
        this.original = original;
        HashMap<String, String> labels = new HashMap<String, String>();
        labels.put(SimpleMonitoringInfoBuilder.PCOLLECTION_LABEL, pCollection);
        MonitoringInfoMetricName metricName = MonitoringInfoMetricName.named(SimpleMonitoringInfoBuilder.ELEMENT_COUNT_URN, labels);
        this.counter = LabeledMetrics.counter(metricName);
        this.unboundMetricContainer = metricContainerRegistry.getUnboundContainer();
    }

    @Override
    public void accept(WindowedValue<T> input) throws Exception {
        try (Closeable close = MetricsEnvironment.scopedMetricsContainer(this.unboundMetricContainer);){
            this.counter.inc(input.getWindows().size());
            this.original.accept(input);
        }
    }
}

