/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.state;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.beam.fn.harness.state.BeamFnStateClient;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Throwables;

public class StateFetchingIterators {
    private StateFetchingIterators() {
    }

    public static Iterator<ByteString> forFirstChunk(BeamFnStateClient beamFnStateClient, BeamFnApi.StateRequest stateRequestForFirstChunk) {
        return new LazyBlockingStateFetchingIterator(beamFnStateClient, stateRequestForFirstChunk);
    }

    static class LazyBlockingStateFetchingIterator
    implements Iterator<ByteString> {
        private final BeamFnStateClient beamFnStateClient;
        private final BeamFnApi.StateRequest stateRequestForFirstChunk;
        private State currentState = State.READ_REQUIRED;
        private ByteString continuationToken;
        private ByteString next;

        LazyBlockingStateFetchingIterator(BeamFnStateClient beamFnStateClient, BeamFnApi.StateRequest stateRequestForFirstChunk) {
            this.beamFnStateClient = beamFnStateClient;
            this.stateRequestForFirstChunk = stateRequestForFirstChunk;
            this.continuationToken = ByteString.EMPTY;
        }

        @Override
        public boolean hasNext() {
            switch (this.currentState) {
                case EOF: {
                    return false;
                }
                case READ_REQUIRED: {
                    BeamFnApi.StateResponse stateResponse;
                    CompletableFuture<BeamFnApi.StateResponse> stateResponseFuture = new CompletableFuture<BeamFnApi.StateResponse>();
                    this.beamFnStateClient.handle(this.stateRequestForFirstChunk.toBuilder().setGet(BeamFnApi.StateGetRequest.newBuilder().setContinuationToken(this.continuationToken)), stateResponseFuture);
                    try {
                        stateResponse = stateResponseFuture.get();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IllegalStateException(e);
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() == null) {
                            throw new IllegalStateException(e);
                        }
                        Throwables.throwIfUnchecked(e.getCause());
                        throw new IllegalStateException(e.getCause());
                    }
                    this.continuationToken = stateResponse.getGet().getContinuationToken();
                    this.next = stateResponse.getGet().getData();
                    this.currentState = State.HAS_NEXT;
                    return true;
                }
                case HAS_NEXT: {
                    return true;
                }
            }
            throw new IllegalStateException(String.format("Unknown state %s", new Object[]{this.currentState}));
        }

        @Override
        public ByteString next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.currentState = ByteString.EMPTY.equals(this.continuationToken) ? State.EOF : State.READ_REQUIRED;
            return this.next;
        }

        private static enum State {
            READ_REQUIRED,
            HAS_NEXT,
            EOF;

        }
    }
}

