/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.build;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Type;
import java.util.Comparator;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.build.Plugin;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.annotation.AnnotationDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.annotation.AnnotationSource;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodList;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.ClassFileLocator;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.EqualsMethod;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.HashCodeMethod;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.matcher.ElementMatcher;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.matcher.ElementMatchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Enhance
public class HashCodeAndEqualsPlugin
implements Plugin,
Plugin.Factory {
    @Override
    public Plugin make() {
        return this;
    }

    @Override
    public boolean matches(TypeDescription target) {
        return target.getDeclaredAnnotations().isAnnotationPresent(Enhance.class);
    }

    @Override
    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        Enhance enhance = typeDescription.getDeclaredAnnotations().ofType(Enhance.class).loadSilent();
        if (((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isHashCode())).isEmpty()) {
            builder = builder.method(ElementMatchers.isHashCode()).intercept(enhance.invokeSuper().hashCodeMethod(typeDescription).withIgnoredFields(enhance.includeSyntheticFields() ? ElementMatchers.none() : ElementMatchers.isSynthetic()).withIgnoredFields(new ValueMatcher(ValueHandling.Sort.IGNORE)).withNonNullableFields(this.nonNullable(new ValueMatcher(ValueHandling.Sort.REVERSE_NULLABILITY))));
        }
        if (((MethodList)typeDescription.getDeclaredMethods().filter(ElementMatchers.isEquals())).isEmpty()) {
            EqualsMethod equalsMethod = enhance.invokeSuper().equalsMethod(typeDescription).withIgnoredFields(enhance.includeSyntheticFields() ? ElementMatchers.none() : ElementMatchers.isSynthetic()).withIgnoredFields(new ValueMatcher(ValueHandling.Sort.IGNORE)).withNonNullableFields(this.nonNullable(new ValueMatcher(ValueHandling.Sort.REVERSE_NULLABILITY))).withFieldOrder(AnnotationOrderComparator.INSTANCE);
            if (enhance.simpleComparisonsFirst()) {
                equalsMethod = equalsMethod.withPrimitiveTypedFieldsFirst().withEnumerationTypedFieldsFirst().withPrimitiveWrapperTypedFieldsFirst().withStringTypedFieldsFirst();
            }
            builder = builder.method(ElementMatchers.isEquals()).intercept(enhance.permitSubclassEquality() ? equalsMethod.withSubclassEquality() : equalsMethod);
        }
        return builder;
    }

    protected ElementMatcher<FieldDescription> nonNullable(ElementMatcher<FieldDescription> matcher) {
        return matcher;
    }

    @Override
    public void close() {
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return this.getClass() == object.getClass();
    }

    public int hashCode() {
        return 17;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Enhance
    protected static class ValueMatcher
    implements ElementMatcher<FieldDescription> {
        private final ValueHandling.Sort sort;

        protected ValueMatcher(ValueHandling.Sort sort) {
            this.sort = sort;
        }

        @Override
        public boolean matches(FieldDescription target) {
            AnnotationDescription.Loadable<ValueHandling> annotation = target.getDeclaredAnnotations().ofType(ValueHandling.class);
            return annotation != null && annotation.loadSilent().value() == this.sort;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            return this.sort.equals((Object)((ValueMatcher)object).sort);
        }

        public int hashCode() {
            return 17 * 31 + this.sort.hashCode();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum AnnotationOrderComparator implements Comparator<FieldDescription.InDefinedShape>
    {
        INSTANCE;


        @Override
        public int compare(FieldDescription.InDefinedShape left, FieldDescription.InDefinedShape right) {
            int rightValue;
            AnnotationDescription.Loadable<Sorted> leftAnnotation = left.getDeclaredAnnotations().ofType(Sorted.class);
            AnnotationDescription.Loadable<Sorted> rightAnnotation = right.getDeclaredAnnotations().ofType(Sorted.class);
            int leftValue = leftAnnotation == null ? 0 : leftAnnotation.loadSilent().value();
            int n = rightValue = rightAnnotation == null ? 0 : rightAnnotation.loadSilent().value();
            if (leftValue > rightValue) {
                return -1;
            }
            if (leftValue < rightValue) {
                return 1;
            }
            return 0;
        }
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Sorted {
        public static final int DEFAULT = 0;

        public int value();
    }

    @Documented
    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ValueHandling {
        public Sort value();

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Sort {
            IGNORE,
            REVERSE_NULLABILITY;

        }
    }

    @Documented
    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Enhance {
        public InvokeSuper invokeSuper() default InvokeSuper.IF_DECLARED;

        public boolean simpleComparisonsFirst() default true;

        public boolean includeSyntheticFields() default false;

        public boolean permitSubclassEquality() default false;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum InvokeSuper {
            IF_DECLARED{

                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType) {
                    for (TypeDescription.Generic typeDefinition = instrumentedType.getSuperClass(); typeDefinition != null && !typeDefinition.represents((Type)((Object)Object.class)); typeDefinition = typeDefinition.getSuperClass()) {
                        if (typeDefinition.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class)) {
                            return HashCodeMethod.usingSuperClassOffset();
                        }
                        MethodList hashCode = (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isHashCode());
                        if (hashCode.isEmpty()) continue;
                        return ((MethodDescription)hashCode.getOnly()).isAbstract() ? HashCodeMethod.usingDefaultOffset() : HashCodeMethod.usingSuperClassOffset();
                    }
                    return HashCodeMethod.usingDefaultOffset();
                }

                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    AnnotationSource typeDefinition = instrumentedType.getSuperClass();
                    while (typeDefinition != null && !typeDefinition.represents((Type)((Object)Object.class))) {
                        if (typeDefinition.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class)) {
                            return EqualsMethod.requiringSuperClassEquality();
                        }
                        MethodList hashCode = (MethodList)typeDefinition.getDeclaredMethods().filter(ElementMatchers.isHashCode());
                        if (!hashCode.isEmpty()) {
                            return ((MethodDescription)hashCode.getOnly()).isAbstract() ? EqualsMethod.isolated() : EqualsMethod.requiringSuperClassEquality();
                        }
                        typeDefinition = typeDefinition.getSuperClass().asErasure();
                    }
                    return EqualsMethod.isolated();
                }
            }
            ,
            IF_ANNOTATED{

                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType) {
                    TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                    return superClass != null && superClass.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class) ? HashCodeMethod.usingSuperClassOffset() : HashCodeMethod.usingDefaultOffset();
                }

                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    TypeDescription.Generic superClass = instrumentedType.getSuperClass();
                    return superClass != null && superClass.asErasure().getDeclaredAnnotations().isAnnotationPresent(Enhance.class) ? EqualsMethod.requiringSuperClassEquality() : EqualsMethod.isolated();
                }
            }
            ,
            ALWAYS{

                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType) {
                    return HashCodeMethod.usingSuperClassOffset();
                }

                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    return EqualsMethod.requiringSuperClassEquality();
                }
            }
            ,
            NEVER{

                protected HashCodeMethod hashCodeMethod(TypeDescription instrumentedType) {
                    return HashCodeMethod.usingDefaultOffset();
                }

                protected EqualsMethod equalsMethod(TypeDescription instrumentedType) {
                    return EqualsMethod.isolated();
                }
            };


            protected abstract HashCodeMethod hashCodeMethod(TypeDescription var1);

            protected abstract EqualsMethod equalsMethod(TypeDescription var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Enhance
    public static class WithNonNullableFields
    extends HashCodeAndEqualsPlugin {
        @Override
        protected ElementMatcher<FieldDescription> nonNullable(ElementMatcher<FieldDescription> matcher) {
            return ElementMatchers.not(matcher);
        }

        @Override
        public boolean equals(Object object) {
            if (!super.equals(object)) {
                return false;
            }
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            return this.getClass() == object.getClass();
        }

        @Override
        public int hashCode() {
            return super.hashCode();
        }
    }
}

