/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger;

import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.KeyValueHandler;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.util.Checks;

public class MetadataKey<T> {
    private final String label;
    private final Class<T> clazz;
    private final boolean canRepeat;

    public static <T> MetadataKey<T> single(String label, Class<T> clazz) {
        return new MetadataKey<T>(label, clazz, false);
    }

    public static <T> MetadataKey<T> repeated(String label, Class<T> clazz) {
        return new MetadataKey<T>(label, clazz, true);
    }

    protected MetadataKey(String label, Class<T> clazz, boolean canRepeat) {
        this.label = Checks.checkMetadataIdentifier(label);
        this.clazz = Checks.checkNotNull(clazz, "class");
        this.canRepeat = canRepeat;
    }

    public final String getLabel() {
        return this.label;
    }

    public final T cast(Object value) {
        return this.clazz.cast(value);
    }

    public final boolean canRepeat() {
        return this.canRepeat;
    }

    public void emit(Object value, KeyValueHandler out) {
        out.handle(this.getLabel(), value);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String toString() {
        return this.getClass().getName() + "/" + this.label + "[" + this.clazz.getName() + "]";
    }
}

