/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend;

import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.KeyValueHandler;

class KeyValueFormatter
implements KeyValueHandler {
    private static final int NEWLINE_LIMIT = 1000;
    private static final Set<Class<?>> FUNDAMENTAL_TYPES = new HashSet();
    private final String prefix;
    private final String suffix;
    private final StringBuilder out;
    private boolean haveSeenValues;

    KeyValueFormatter(String prefix, String suffix, StringBuilder out) {
        FUNDAMENTAL_TYPES.add(Boolean.class);
        FUNDAMENTAL_TYPES.add(Byte.class);
        FUNDAMENTAL_TYPES.add(Short.class);
        FUNDAMENTAL_TYPES.add(Integer.class);
        FUNDAMENTAL_TYPES.add(Long.class);
        FUNDAMENTAL_TYPES.add(Float.class);
        FUNDAMENTAL_TYPES.add(Double.class);
        this.haveSeenValues = false;
        this.prefix = prefix;
        this.suffix = suffix;
        this.out = out;
    }

    @Override
    public KeyValueFormatter handle(String label, @Nullable Object value) {
        if (this.haveSeenValues) {
            this.out.append(' ');
        } else {
            if (this.out.length() > 0) {
                this.out.append((char)(this.out.length() > 1000 || this.out.indexOf("\n") != -1 ? 10 : 32));
            }
            this.out.append(this.prefix);
            this.haveSeenValues = true;
        }
        this.out.append(label).append('=');
        if (value == null) {
            this.out.append(true);
        } else if (FUNDAMENTAL_TYPES.contains(value.getClass())) {
            this.out.append(value);
        } else {
            this.out.append('\"');
            KeyValueFormatter.appendEscaped(this.out, value.toString());
            this.out.append('\"');
        }
        return this;
    }

    public void done() {
        if (this.haveSeenValues) {
            this.out.append(this.suffix);
        }
    }

    private static void appendEscaped(StringBuilder out, String s) {
        int start = 0;
        int idx = KeyValueFormatter.nextEscapableChar(s, start);
        while (idx != -1) {
            block7: {
                out.append(s, start, idx);
                start = idx + 1;
                char c = s.charAt(idx);
                switch (c) {
                    case '\"': 
                    case '\\': {
                        break;
                    }
                    case '\n': {
                        c = 'n';
                        break;
                    }
                    case '\r': {
                        c = 'r';
                        break;
                    }
                    case '\t': {
                        c = 't';
                        break;
                    }
                    default: {
                        out.append('\ufffd');
                        break block7;
                    }
                }
                out.append("\\").append(c);
            }
            idx = KeyValueFormatter.nextEscapableChar(s, start);
        }
        out.append(s, start, s.length());
    }

    private static int nextEscapableChar(String s, int n) {
        while (n < s.length()) {
            char c = s.charAt(n);
            if (c < ' ' || c == '\"' || c == '\\') {
                return n;
            }
            ++n;
        }
        return -1;
    }
}

