/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Formattable;
import java.util.Formatter;
import java.util.Locale;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.LogContext;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.MetadataKey;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.FormatChar;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.FormatOptions;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.KeyValueFormatter;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.LogData;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.Metadata;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.Tags;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.backend.TemplateContext;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.parameter.DateTimeFormat;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.parameter.Parameter;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.parameter.ParameterVisitor;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.parser.MessageBuilder;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.util.Checks;

public final class SimpleMessageFormatter
extends MessageBuilder<StringBuilder>
implements ParameterVisitor {
    private static final String MISSING_ARGUMENT_MESSAGE = "[ERROR: MISSING LOG ARGUMENT]";
    private static final String EXTRA_ARGUMENT_MESSAGE = " [ERROR: UNUSED LOG ARGUMENTS]";
    private static final Locale FORMAT_LOCALE = Locale.ROOT;
    private final Object[] args;
    private final StringBuilder out = new StringBuilder();
    private int literalStart = 0;

    public static void format(LogData logData, SimpleLogHandler receiver) {
        String message;
        Metadata metadata = logData.getMetadata();
        Throwable thrown = metadata.findValue(LogContext.Key.LOG_CAUSE);
        boolean hasOnlyKnownMetadata = metadata.size() == 0 || metadata.size() == 1 && thrown != null;
        TemplateContext ctx = logData.getTemplateContext();
        if (ctx == null) {
            message = SimpleMessageFormatter.safeToString(logData.getLiteralArgument());
            if (!hasOnlyKnownMetadata) {
                message = SimpleMessageFormatter.appendContext(new StringBuilder(message), metadata);
            }
        } else {
            StringBuilder buffer = SimpleMessageFormatter.formatMessage(logData);
            message = hasOnlyKnownMetadata ? buffer.toString() : SimpleMessageFormatter.appendContext(buffer, metadata);
        }
        receiver.handleFormattedLogMessage(logData.getLevel(), message, thrown);
    }

    public static String safeToString(Object value) {
        try {
            return value != null ? SimpleMessageFormatter.toString(value) : "null";
        }
        catch (RuntimeException e) {
            return SimpleMessageFormatter.getErrorString(value, e);
        }
    }

    private static void safeFormatTo(Formattable value, StringBuilder out, FormatOptions options) {
        int formatFlags = options.getFlags() & 0xA2;
        if (formatFlags != 0) {
            formatFlags = ((formatFlags & 0x20) != 0 ? 1 : 0) | ((formatFlags & 0x80) != 0 ? 2 : 0) | ((formatFlags & 2) != 0 ? 4 : 0);
        }
        int originalLength = out.length();
        Formatter formatter = new Formatter(out, FORMAT_LOCALE);
        try {
            value.formatTo(formatter, formatFlags, options.getWidth(), options.getPrecision());
        }
        catch (RuntimeException e) {
            out.setLength(originalLength);
            try {
                formatter.out().append(SimpleMessageFormatter.getErrorString(value, e));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getErrorString(Object value, RuntimeException e) {
        String errorMessage;
        try {
            errorMessage = e.toString();
        }
        catch (RuntimeException wtf) {
            errorMessage = wtf.getClass().getSimpleName();
        }
        return "{" + value.getClass().getName() + "@" + System.identityHashCode(value) + ": " + errorMessage + "}";
    }

    private static StringBuilder formatMessage(LogData logData) {
        SimpleMessageFormatter formatter = new SimpleMessageFormatter(logData.getTemplateContext(), logData.getArguments());
        StringBuilder out = (StringBuilder)formatter.build();
        if (logData.getArguments().length > formatter.getExpectedArgumentCount()) {
            out.append(EXTRA_ARGUMENT_MESSAGE);
        }
        return out;
    }

    private static String appendContext(StringBuilder out, Metadata metadata) {
        KeyValueFormatter kvf = new KeyValueFormatter("[CONTEXT ", " ]", out);
        Tags tags = null;
        for (int n = 0; n < metadata.size(); ++n) {
            MetadataKey<?> key = metadata.getKey(n);
            if (key.equals(LogContext.Key.LOG_CAUSE)) continue;
            if (key.equals(LogContext.Key.TAGS)) {
                tags = LogContext.Key.TAGS.cast(metadata.getValue(n));
                continue;
            }
            key.emit(metadata.getValue(n), kvf);
        }
        if (tags != null) {
            tags.emitAll(kvf);
        }
        kvf.done();
        return out.toString();
    }

    private SimpleMessageFormatter(TemplateContext context, Object[] args) {
        super(context);
        this.args = Checks.checkNotNull(args, "log arguments");
    }

    @Override
    public void addParameterImpl(int termStart, int termEnd, Parameter param) {
        this.getParser().unescape(this.out, this.getMessage(), this.literalStart, termStart);
        param.accept((ParameterVisitor)this, this.args);
        this.literalStart = termEnd;
    }

    @Override
    public StringBuilder buildImpl() {
        this.getParser().unescape(this.out, this.getMessage(), this.literalStart, this.getMessage().length());
        return this.out;
    }

    @Override
    public void visit(Object value, FormatChar format, FormatOptions options) {
        if (format.getType().canFormat(value)) {
            SimpleMessageFormatter.appendFormatted(this.out, value, format, options);
        } else {
            SimpleMessageFormatter.appendInvalid(this.out, value, format.getDefaultFormatString());
        }
    }

    @Override
    public void visitDateTime(Object value, DateTimeFormat format, FormatOptions options) {
        if (value instanceof Date || value instanceof Calendar || value instanceof Long) {
            String formatString = options.appendPrintfOptions(new StringBuilder("%")).append(options.shouldUpperCase() ? (char)'T' : 't').append(format.getChar()).toString();
            this.out.append(String.format(FORMAT_LOCALE, formatString, value));
        } else {
            SimpleMessageFormatter.appendInvalid(this.out, value, "%t" + format.getChar());
        }
    }

    @Override
    public void visitPreformatted(Object value, String formatted) {
        this.out.append(formatted);
    }

    @Override
    public void visitMissing() {
        this.out.append(MISSING_ARGUMENT_MESSAGE);
    }

    @Override
    public void visitNull() {
        this.out.append("null");
    }

    private static void appendFormatted(StringBuilder out, Object value, FormatChar format, FormatOptions options) {
        switch (format) {
            case STRING: {
                if (!(value instanceof Formattable)) {
                    if (!options.isDefault()) break;
                    out.append(SimpleMessageFormatter.safeToString(value));
                    return;
                }
                SimpleMessageFormatter.safeFormatTo((Formattable)value, out, options);
                return;
            }
            case DECIMAL: 
            case BOOLEAN: {
                if (!options.isDefault()) break;
                out.append(value);
                return;
            }
            case HEX: {
                if (!options.filter(128, false, false).equals(options)) break;
                SimpleMessageFormatter.appendHex(out, (Number)value, options);
                return;
            }
            case CHAR: {
                if (!options.isDefault()) break;
                if (value instanceof Character) {
                    out.append(value);
                    return;
                }
                int codePoint = ((Number)value).intValue();
                if (Character.isBmpCodePoint(codePoint)) {
                    out.append((char)codePoint);
                    return;
                }
                out.append(Character.toChars(codePoint));
                return;
            }
        }
        String formatString = format.getDefaultFormatString();
        if (!options.isDefault()) {
            char chr = format.getChar();
            if (options.shouldUpperCase()) {
                chr = (char)(chr & 0xFFDF);
            }
            formatString = options.appendPrintfOptions(new StringBuilder("%")).append(chr).toString();
        }
        out.append(String.format(FORMAT_LOCALE, formatString, value));
    }

    static void appendHex(StringBuilder out, Number number, FormatOptions options) {
        boolean isUpper = options.shouldUpperCase();
        long n = number.longValue();
        if (number instanceof Long) {
            SimpleMessageFormatter.appendHex(out, n, isUpper);
        } else if (number instanceof Integer) {
            SimpleMessageFormatter.appendHex(out, n & 0xFFFFFFFFL, isUpper);
        } else if (number instanceof Byte) {
            SimpleMessageFormatter.appendHex(out, n & 0xFFL, isUpper);
        } else if (number instanceof Short) {
            SimpleMessageFormatter.appendHex(out, n & 0xFFFFL, isUpper);
        } else if (number instanceof BigInteger) {
            String hex = ((BigInteger)number).toString(16);
            out.append(isUpper ? hex.toUpperCase(FORMAT_LOCALE) : hex);
        } else {
            throw new RuntimeException("unsupported number type: " + number.getClass());
        }
    }

    private static void appendHex(StringBuilder out, long n, boolean isUpper) {
        if (n == 0L) {
            out.append("0");
        } else {
            String hexChars = isUpper ? "0123456789ABCDEF" : "0123456789abcdef";
            for (int shift = 63 - Long.numberOfLeadingZeros(n) & 0xFFFFFFFC; shift >= 0; shift -= 4) {
                out.append(hexChars.charAt((int)(n >>> shift & 0xFL)));
            }
        }
    }

    private static void appendInvalid(StringBuilder out, Object value, String formatString) {
        out.append("[INVALID: format=").append(formatString).append(", type=").append(value.getClass().getCanonicalName()).append(", value=").append(SimpleMessageFormatter.safeToString(value)).append("]");
    }

    static String toString(Object value) {
        if (!value.getClass().isArray()) {
            return String.valueOf(value);
        }
        if (value instanceof int[]) {
            return Arrays.toString((int[])value);
        }
        if (value instanceof long[]) {
            return Arrays.toString((long[])value);
        }
        if (value instanceof byte[]) {
            return Arrays.toString((byte[])value);
        }
        if (value instanceof char[]) {
            return Arrays.toString((char[])value);
        }
        if (value instanceof short[]) {
            return Arrays.toString((short[])value);
        }
        if (value instanceof float[]) {
            return Arrays.toString((float[])value);
        }
        if (value instanceof double[]) {
            return Arrays.toString((double[])value);
        }
        if (value instanceof boolean[]) {
            return Arrays.toString((boolean[])value);
        }
        return Arrays.toString((Object[])value);
    }

    public static interface SimpleLogHandler {
        public void handleFormattedLogMessage(Level var1, String var2, @Nullable Throwable var3);
    }
}

