/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.util;

import com.google.errorprone.annotations.CheckReturnValue;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.LogSite;
import org.apache.beam.repackaged.beam_sdks_java_harness.com.google.common.flogger.util.Checks;

@CheckReturnValue
public final class StackBasedLogSite
extends LogSite {
    private final StackTraceElement stackElement;

    public StackBasedLogSite(StackTraceElement stackElement) {
        this.stackElement = Checks.checkNotNull(stackElement, "stack element");
    }

    @Override
    public String getClassName() {
        return this.stackElement.getClassName();
    }

    @Override
    public String getMethodName() {
        return this.stackElement.getMethodName();
    }

    @Override
    public int getLineNumber() {
        return Math.max(this.stackElement.getLineNumber(), 0);
    }

    @Override
    public String getFileName() {
        return this.stackElement.getFileName();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof StackBasedLogSite && this.stackElement.equals(((StackBasedLogSite)obj).stackElement);
    }

    public int hashCode() {
        return this.stackElement.hashCode();
    }
}

