/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.state.TimeDomain;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.util.WindowTracing;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Table;
import org.joda.time.Instant;

public class InMemoryTimerInternals
implements TimerInternals {
    Table<StateNamespace, String, TimerInternals.TimerData> existingTimers = HashBasedTable.create();
    private NavigableSet<TimerInternals.TimerData> watermarkTimers = new TreeSet<TimerInternals.TimerData>();
    private NavigableSet<TimerInternals.TimerData> processingTimers = new TreeSet<TimerInternals.TimerData>();
    private NavigableSet<TimerInternals.TimerData> synchronizedProcessingTimers = new TreeSet<TimerInternals.TimerData>();
    private Instant inputWatermarkTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    @Nullable
    private Instant outputWatermarkTime = null;
    private Instant processingTime = BoundedWindow.TIMESTAMP_MIN_VALUE;
    private Instant synchronizedProcessingTime = BoundedWindow.TIMESTAMP_MIN_VALUE;

    @Override
    @Nullable
    public Instant currentOutputWatermarkTime() {
        return this.outputWatermarkTime;
    }

    @Nullable
    public Instant getNextTimer(TimeDomain domain) {
        try {
            switch (domain) {
                case EVENT_TIME: {
                    return ((TimerInternals.TimerData)this.watermarkTimers.first()).getTimestamp();
                }
                case PROCESSING_TIME: {
                    return ((TimerInternals.TimerData)this.processingTimers.first()).getTimestamp();
                }
                case SYNCHRONIZED_PROCESSING_TIME: {
                    return ((TimerInternals.TimerData)this.synchronizedProcessingTimers.first()).getTimestamp();
                }
            }
            throw new IllegalArgumentException("Unexpected time domain: " + (Object)((Object)domain));
        }
        catch (NoSuchElementException exc) {
            return null;
        }
    }

    private NavigableSet<TimerInternals.TimerData> timersForDomain(TimeDomain domain) {
        switch (domain) {
            case EVENT_TIME: {
                return this.watermarkTimers;
            }
            case PROCESSING_TIME: {
                return this.processingTimers;
            }
            case SYNCHRONIZED_PROCESSING_TIME: {
                return this.synchronizedProcessingTimers;
            }
        }
        throw new IllegalArgumentException("Unexpected time domain: " + (Object)((Object)domain));
    }

    @Override
    public void setTimer(StateNamespace namespace, String timerId, Instant target, TimeDomain timeDomain) {
        this.setTimer(TimerInternals.TimerData.of(timerId, namespace, target, timeDomain));
    }

    @Override
    @Deprecated
    public void setTimer(TimerInternals.TimerData timerData) {
        WindowTracing.trace("{}.setTimer: {}", this.getClass().getSimpleName(), timerData);
        TimerInternals.TimerData existing = this.existingTimers.get(timerData.getNamespace(), timerData.getTimerId());
        if (existing == null) {
            this.existingTimers.put(timerData.getNamespace(), timerData.getTimerId(), timerData);
            this.timersForDomain(timerData.getDomain()).add(timerData);
        } else {
            Preconditions.checkArgument(timerData.getDomain().equals((Object)existing.getDomain()), "Attempt to set %s for time domain %s, but it is already set for time domain %s", (Object)timerData.getTimerId(), (Object)timerData.getDomain(), (Object)existing.getDomain());
            if (!timerData.getTimestamp().equals(existing.getTimestamp())) {
                NavigableSet<TimerInternals.TimerData> timers = this.timersForDomain(timerData.getDomain());
                timers.remove(existing);
                timers.add(timerData);
                this.existingTimers.put(timerData.getNamespace(), timerData.getTimerId(), timerData);
            }
        }
    }

    @Override
    public void deleteTimer(StateNamespace namespace, String timerId, TimeDomain timeDomain) {
        throw new UnsupportedOperationException("Canceling a timer by ID is not yet supported.");
    }

    @Override
    @Deprecated
    public void deleteTimer(StateNamespace namespace, String timerId) {
        TimerInternals.TimerData existing = this.existingTimers.get(namespace, timerId);
        if (existing != null) {
            this.deleteTimer(existing);
        }
    }

    @Override
    @Deprecated
    public void deleteTimer(TimerInternals.TimerData timer) {
        WindowTracing.trace("{}.deleteTimer: {}", this.getClass().getSimpleName(), timer);
        this.existingTimers.remove(timer.getNamespace(), timer.getTimerId());
        this.timersForDomain(timer.getDomain()).remove(timer);
    }

    @Override
    public Instant currentProcessingTime() {
        return this.processingTime;
    }

    @Override
    @Nullable
    public Instant currentSynchronizedProcessingTime() {
        return this.synchronizedProcessingTime;
    }

    @Override
    public Instant currentInputWatermarkTime() {
        return this.inputWatermarkTime;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("watermarkTimers", this.watermarkTimers).add("processingTimers", this.processingTimers).add("synchronizedProcessingTimers", this.synchronizedProcessingTimers).add("inputWatermarkTime", this.inputWatermarkTime).add("outputWatermarkTime", this.outputWatermarkTime).add("processingTime", this.processingTime).toString();
    }

    public void advanceInputWatermark(Instant newInputWatermark) throws Exception {
        Preconditions.checkNotNull(newInputWatermark);
        Preconditions.checkState(!newInputWatermark.isBefore(this.inputWatermarkTime), "Cannot move input watermark time backwards from %s to %s", (Object)this.inputWatermarkTime, (Object)newInputWatermark);
        WindowTracing.trace("{}.advanceInputWatermark: from {} to {}", this.getClass().getSimpleName(), this.inputWatermarkTime, newInputWatermark);
        this.inputWatermarkTime = newInputWatermark;
    }

    public void advanceOutputWatermark(Instant newOutputWatermark) {
        Instant adjustedOutputWatermark;
        Preconditions.checkNotNull(newOutputWatermark);
        if (newOutputWatermark.isAfter(this.inputWatermarkTime)) {
            WindowTracing.trace("{}.advanceOutputWatermark: clipping output watermark from {} to {}", this.getClass().getSimpleName(), newOutputWatermark, this.inputWatermarkTime);
            adjustedOutputWatermark = this.inputWatermarkTime;
        } else {
            adjustedOutputWatermark = newOutputWatermark;
        }
        Preconditions.checkState(this.outputWatermarkTime == null || !adjustedOutputWatermark.isBefore(this.outputWatermarkTime), "Cannot move output watermark time backwards from %s to %s", (Object)this.outputWatermarkTime, (Object)adjustedOutputWatermark);
        WindowTracing.trace("{}.advanceOutputWatermark: from {} to {}", this.getClass().getSimpleName(), this.outputWatermarkTime, adjustedOutputWatermark);
        this.outputWatermarkTime = adjustedOutputWatermark;
    }

    public void advanceProcessingTime(Instant newProcessingTime) throws Exception {
        Preconditions.checkNotNull(newProcessingTime);
        Preconditions.checkState(!newProcessingTime.isBefore(this.processingTime), "Cannot move processing time backwards from %s to %s", (Object)this.processingTime, (Object)newProcessingTime);
        WindowTracing.trace("{}.advanceProcessingTime: from {} to {}", this.getClass().getSimpleName(), this.processingTime, newProcessingTime);
        this.processingTime = newProcessingTime;
    }

    public void advanceSynchronizedProcessingTime(Instant newSynchronizedProcessingTime) throws Exception {
        Preconditions.checkNotNull(newSynchronizedProcessingTime);
        Preconditions.checkState(!newSynchronizedProcessingTime.isBefore(this.synchronizedProcessingTime), "Cannot move processing time backwards from %s to %s", (Object)this.synchronizedProcessingTime, (Object)newSynchronizedProcessingTime);
        WindowTracing.trace("{}.advanceProcessingTime: from {} to {}", this.getClass().getSimpleName(), this.synchronizedProcessingTime, newSynchronizedProcessingTime);
        this.synchronizedProcessingTime = newSynchronizedProcessingTime;
    }

    @Nullable
    public TimerInternals.TimerData removeNextEventTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.inputWatermarkTime, TimeDomain.EVENT_TIME);
        if (timer != null) {
            WindowTracing.trace("{}.removeNextEventTimer: firing {} at {}", this.getClass().getSimpleName(), timer, this.inputWatermarkTime);
        }
        return timer;
    }

    @Nullable
    public TimerInternals.TimerData removeNextProcessingTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.processingTime, TimeDomain.PROCESSING_TIME);
        if (timer != null) {
            WindowTracing.trace("{}.removeNextProcessingTimer: firing {} at {}", this.getClass().getSimpleName(), timer, this.processingTime);
        }
        return timer;
    }

    @Nullable
    public TimerInternals.TimerData removeNextSynchronizedProcessingTimer() {
        TimerInternals.TimerData timer = this.removeNextTimer(this.synchronizedProcessingTime, TimeDomain.SYNCHRONIZED_PROCESSING_TIME);
        if (timer != null) {
            WindowTracing.trace("{}.removeNextSynchronizedProcessingTimer: firing {} at {}", this.getClass().getSimpleName(), timer, this.synchronizedProcessingTime);
        }
        return timer;
    }

    @Nullable
    private TimerInternals.TimerData removeNextTimer(Instant currentTime, TimeDomain domain) {
        NavigableSet<TimerInternals.TimerData> timers = this.timersForDomain(domain);
        if (!timers.isEmpty() && currentTime.isAfter(((TimerInternals.TimerData)timers.first()).getTimestamp())) {
            TimerInternals.TimerData timer = timers.pollFirst();
            this.existingTimers.remove(timer.getNamespace(), timer.getTimerId());
            return timer;
        }
        return null;
    }
}

