/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.Collections;
import java.util.Objects;
import org.apache.beam.runners.core.KeyedWorkItem;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Iterables;

public class KeyedWorkItems {
    public static <K, ElemT> KeyedWorkItem<K, ElemT> elementsWorkItem(K key, Iterable<WindowedValue<ElemT>> elementsIterable) {
        return new ComposedKeyedWorkItem(key, Collections.emptyList(), elementsIterable);
    }

    public static <K, ElemT> KeyedWorkItem<K, ElemT> timersWorkItem(K key, Iterable<TimerInternals.TimerData> timersIterable) {
        return new ComposedKeyedWorkItem(key, timersIterable, Collections.emptyList());
    }

    public static <K, ElemT> KeyedWorkItem<K, ElemT> workItem(K key, Iterable<TimerInternals.TimerData> timersIterable, Iterable<WindowedValue<ElemT>> elementsIterable) {
        return new ComposedKeyedWorkItem(key, timersIterable, elementsIterable);
    }

    public static class ComposedKeyedWorkItem<K, ElemT>
    implements KeyedWorkItem<K, ElemT> {
        private final K key;
        private final Iterable<TimerInternals.TimerData> timers;
        private final Iterable<WindowedValue<ElemT>> elements;

        private ComposedKeyedWorkItem(K key, Iterable<TimerInternals.TimerData> timers, Iterable<WindowedValue<ElemT>> elements) {
            this.key = key;
            this.timers = timers;
            this.elements = elements;
        }

        @Override
        public K key() {
            return this.key;
        }

        @Override
        public Iterable<TimerInternals.TimerData> timersIterable() {
            return this.timers;
        }

        @Override
        public Iterable<WindowedValue<ElemT>> elementsIterable() {
            return this.elements;
        }

        public boolean equals(Object other) {
            if (other == null || !(other instanceof ComposedKeyedWorkItem)) {
                return false;
            }
            KeyedWorkItem that = (KeyedWorkItem)other;
            return Objects.equals(this.key, that.key()) && Iterables.elementsEqual(this.timersIterable(), that.timersIterable()) && Iterables.elementsEqual(this.elementsIterable(), that.elementsIterable());
        }

        public int hashCode() {
            return Objects.hash(this.key, this.timers, this.elements);
        }

        public String toString() {
            return MoreObjects.toStringHelper(ComposedKeyedWorkItem.class).add("key", this.key).add("elements", this.elements).add("timers", this.timers).toString();
        }
    }
}

