/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.StateNamespace;
import org.apache.beam.runners.core.StateTag;
import org.apache.beam.runners.core.StateTags;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.state.StateContext;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Equivalence;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Table;

public abstract class StateTable {
    private final Table<StateNamespace, Equivalence.Wrapper<StateTag>, State> stateTable = HashBasedTable.create();

    public <StateT extends State> StateT get(StateNamespace namespace, StateTag<StateT> tag, StateContext<?> c) {
        Equivalence.Wrapper<StateTag> tagById = StateTags.ID_EQUIVALENCE.wrap(tag);
        State storage = this.getOrNull(namespace, tagById, c);
        if (storage != null) {
            State typedStorage = storage;
            return (StateT)typedStorage;
        }
        StateT typedStorage = tag.bind(this.binderForNamespace(namespace, c));
        this.stateTable.put(namespace, tagById, (State)typedStorage);
        return typedStorage;
    }

    @Nullable
    public State getOrNull(StateNamespace namespace, Equivalence.Wrapper<StateTag> tag, StateContext<?> c) {
        return this.stateTable.get(namespace, tag);
    }

    public void clearNamespace(StateNamespace namespace) {
        this.stateTable.rowKeySet().remove(namespace);
    }

    public void clear() {
        this.stateTable.clear();
    }

    public Iterable<State> values() {
        return this.stateTable.values();
    }

    public boolean isNamespaceInUse(StateNamespace namespace) {
        return this.stateTable.containsRow(namespace);
    }

    public Map<StateTag, State> getTagsInUse(StateNamespace namespace) {
        Map<Equivalence.Wrapper<StateTag>, State> row = this.stateTable.row(namespace);
        HashMap<StateTag, State> result = new HashMap<StateTag, State>();
        for (Map.Entry<Equivalence.Wrapper<StateTag>, State> entry : row.entrySet()) {
            result.put(entry.getKey().get(), entry.getValue());
        }
        return result;
    }

    public Set<StateNamespace> getNamespacesInUse() {
        return this.stateTable.rowKeySet();
    }

    protected abstract StateTag.StateBinder binderForNamespace(StateNamespace var1, StateContext<?> var2);
}

