/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.io.IOException;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.core.construction.RehydratedComponents;
import org.apache.beam.runners.core.construction.RunnerPCollectionView;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.protobuf.InvalidProtocolBufferException;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class PCollectionViewTranslation {
    public static PCollectionView<?> viewFromProto(RunnerApi.SideInput sideInput, String localName, PCollection<?> pCollection, RunnerApi.PTransform parDoTransform, RehydratedComponents components) throws IOException {
        Preconditions.checkArgument(localName != null, "%s.viewFromProto: localName must not be null", (Object)ParDoTranslation.class.getSimpleName());
        TupleTag tag = new TupleTag(localName);
        WindowMappingFn<?> windowMappingFn = PCollectionViewTranslation.windowMappingFnFromProto(sideInput.getWindowMappingFn());
        ViewFn<?, ?> viewFn = PCollectionViewTranslation.viewFnFromProto(sideInput.getViewFn());
        WindowingStrategy<?, ?> windowingStrategy = pCollection.getWindowingStrategy().fixDefaults();
        Preconditions.checkArgument(sideInput.getAccessPattern().getUrn().equals("urn:beam:sideinput:materialization:multimap:0.1"), "Unknown View Materialization URN %s", (Object)sideInput.getAccessPattern().getUrn());
        RunnerPCollectionView view = new RunnerPCollectionView(pCollection, tag, viewFn, windowMappingFn, windowingStrategy, pCollection.getCoder());
        return view;
    }

    public static ViewFn<?, ?> viewFnFromProto(RunnerApi.SdkFunctionSpec viewFn) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec spec = viewFn.getSpec();
        Preconditions.checkArgument(spec.getUrn().equals("urn:beam:viewfn:javasdk:0.1"), "Can't deserialize unknown %s type %s", (Object)ViewFn.class.getSimpleName(), (Object)spec.getUrn());
        return (ViewFn)SerializableUtils.deserializeFromByteArray(spec.getPayload().toByteArray(), "Custom ViewFn");
    }

    public static WindowMappingFn<?> windowMappingFnFromProto(RunnerApi.SdkFunctionSpec windowMappingFn) throws InvalidProtocolBufferException {
        RunnerApi.FunctionSpec spec = windowMappingFn.getSpec();
        Preconditions.checkArgument(spec.getUrn().equals("urn:beam:windowmappingfn:javasdk:0.1"), "Can't deserialize unknown %s type %s", (Object)WindowMappingFn.class.getSimpleName(), (Object)spec.getUrn());
        return (WindowMappingFn)SerializableUtils.deserializeFromByteArray(spec.getPayload().toByteArray(), "Custom WinodwMappingFn");
    }
}

