/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.ViewFn;
import org.apache.beam.sdk.transforms.windowing.WindowMappingFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;

public class RunnerPCollectionView<T>
extends PValueBase
implements PCollectionView<T> {
    private final TupleTag<Iterable<WindowedValue<?>>> tag;
    private final ViewFn<Iterable<WindowedValue<?>>, T> viewFn;
    private final WindowMappingFn<?> windowMappingFn;
    @Nullable
    private final WindowingStrategy<?, ?> windowingStrategy;
    @Nullable
    private final Coder<?> coder;
    @Nullable
    private final transient PCollection<?> pCollection;

    public RunnerPCollectionView(@Nullable PCollection<?> pCollection, TupleTag<Iterable<WindowedValue<?>>> tag, ViewFn<Iterable<WindowedValue<?>>, T> viewFn, WindowMappingFn<?> windowMappingFn, @Nullable WindowingStrategy<?, ?> windowingStrategy, @Nullable Coder<?> coder) {
        this.pCollection = pCollection;
        this.tag = tag;
        this.viewFn = viewFn;
        this.windowMappingFn = windowMappingFn;
        this.windowingStrategy = windowingStrategy;
        this.coder = coder;
    }

    @Override
    public PCollection<?> getPCollection() {
        return this.pCollection;
    }

    @Override
    public TupleTag<Iterable<WindowedValue<?>>> getTagInternal() {
        return this.tag;
    }

    @Override
    public ViewFn<Iterable<WindowedValue<?>>, T> getViewFn() {
        return this.viewFn;
    }

    @Override
    public WindowMappingFn<?> getWindowMappingFn() {
        return this.windowMappingFn;
    }

    @Override
    public WindowingStrategy<?, ?> getWindowingStrategyInternal() {
        return this.windowingStrategy;
    }

    @Override
    public Coder<?> getCoderInternal() {
        return this.coder;
    }

    @Override
    public Map<TupleTag<?>, PValue> expand() {
        throw new UnsupportedOperationException(String.format("A %s cannot be expanded", RunnerPCollectionView.class.getSimpleName()));
    }

    public boolean equals(Object other) {
        if (!(other instanceof PCollectionView)) {
            return false;
        }
        PCollectionView otherView = (PCollectionView)other;
        return this.tag.equals(otherView.getTagInternal());
    }

    public int hashCode() {
        return Objects.hash(this.tag);
    }
}

