/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.common.ReflectHelpers;

public class SerializablePipelineOptions
implements Serializable {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModules(ObjectMapper.findModules(ReflectHelpers.findClassLoader()));
    private final String serializedPipelineOptions;
    private transient PipelineOptions options;

    public SerializablePipelineOptions(PipelineOptions options) {
        this.serializedPipelineOptions = SerializablePipelineOptions.serializeToJson(options);
        this.options = options;
        FileSystems.setDefaultPipelineOptions(options);
    }

    public SerializablePipelineOptions(String json) {
        this.serializedPipelineOptions = json;
        this.options = SerializablePipelineOptions.deserializeFromJson(json);
        FileSystems.setDefaultPipelineOptions(this.options);
    }

    public PipelineOptions get() {
        return this.options;
    }

    private void readObject(ObjectInputStream is) throws IOException, ClassNotFoundException {
        is.defaultReadObject();
        this.options = SerializablePipelineOptions.deserializeFromJson(this.serializedPipelineOptions);
        FileSystems.setDefaultPipelineOptions(this.options);
    }

    private static String serializeToJson(PipelineOptions options) {
        try {
            return MAPPER.writeValueAsString(options);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Failed to serialize PipelineOptions", e);
        }
    }

    private static PipelineOptions deserializeFromJson(String options) {
        try {
            return MAPPER.readValue(options, PipelineOptions.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to deserialize PipelineOptions", e);
        }
    }

    public String toString() {
        return this.serializedPipelineOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializablePipelineOptions that = (SerializablePipelineOptions)o;
        return this.serializedPipelineOptions.equals(that.serializedPipelineOptions);
    }

    public int hashCode() {
        return Objects.hash(this.serializedPipelineOptions, this.options);
    }
}

