/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.construction.AutoValue_Timer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.joda.time.Instant;

@AutoValue
public abstract class Timer<T> {
    public static Timer<Void> of(Instant time) {
        return Timer.of(time, null);
    }

    public static <T> Timer<T> of(Instant timestamp, @Nullable T payload) {
        return new AutoValue_Timer<T>(timestamp, payload);
    }

    public abstract Instant getTimestamp();

    @Nullable
    public abstract T getPayload();

    public static class Coder<T>
    extends StructuredCoder<Timer<T>> {
        private final org.apache.beam.sdk.coders.Coder<T> payloadCoder;

        public static <T> Coder of(org.apache.beam.sdk.coders.Coder<T> payloadCoder) {
            return new Coder<T>(payloadCoder);
        }

        private Coder(org.apache.beam.sdk.coders.Coder<T> payloadCoder) {
            this.payloadCoder = payloadCoder;
        }

        @Override
        public void encode(Timer<T> timer, OutputStream outStream) throws CoderException, IOException {
            InstantCoder.of().encode(timer.getTimestamp(), outStream);
            this.payloadCoder.encode(timer.getPayload(), outStream);
        }

        @Override
        public Timer<T> decode(InputStream inStream) throws CoderException, IOException {
            Instant instant = InstantCoder.of().decode(inStream);
            T value = this.payloadCoder.decode(inStream);
            return Timer.of(instant, value);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return Collections.singletonList(this.payloadCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            Coder.verifyDeterministic(this, "Payload coder must be deterministic", this.payloadCoder);
        }

        @Override
        public boolean consistentWithEquals() {
            return this.payloadCoder.consistentWithEquals();
        }

        @Override
        public Object structuralValue(Timer<T> value) {
            return Timer.of(value.getTimestamp(), this.payloadCoder.structuralValue(value.getPayload()));
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(Timer<T> value) {
            return this.payloadCoder.isRegisterByteSizeObserverCheap(value.getPayload());
        }

        @Override
        public void registerByteSizeObserver(Timer<T> value, ElementByteSizeObserver observer) throws Exception {
            InstantCoder.of().registerByteSizeObserver(value.getTimestamp(), observer);
            this.payloadCoder.registerByteSizeObserver(value.getPayload(), observer);
        }
    }
}

