/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;

public class TransformInputs {
    public static Collection<PValue> nonAdditionalInputs(AppliedPTransform<?, ?, ?> application) {
        ImmutableList.Builder mainInputs = ImmutableList.builder();
        Object transform = application.getTransform();
        for (Map.Entry<TupleTag<?>, PValue> input : application.getInputs().entrySet()) {
            if (((PTransform)transform).getAdditionalInputs().containsKey(input.getKey())) continue;
            mainInputs.add(input.getValue());
        }
        Preconditions.checkArgument(!mainInputs.build().isEmpty() || application.getInputs().isEmpty(), "Expected at least one main input if any inputs exist");
        return mainInputs.build();
    }
}

