/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.construction.graph;

import java.util.HashMap;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.BeamUrns;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public class PipelineValidator {
    private static final ImmutableMap<String, TransformValidator> VALIDATORS = ImmutableMap.builder().put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.Primitives.PAR_DO), PipelineValidator::validateParDo).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.Primitives.ASSIGN_WINDOWS), PipelineValidator::validateAssignWindows).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.Primitives.TEST_STREAM), PipelineValidator::validateTestStream).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.Composites.COMBINE_PER_KEY), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.Composites.COMBINE_GLOBALLY), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PGBKCV), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_MERGE_ACCUMULATORS), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_EXTRACT_OUTPUTS), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_PRECOMBINE), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_MERGE_ACCUMULATORS), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_PER_KEY_EXTRACT_OUTPUTS), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.CombineComponents.COMBINE_GROUPED_VALUES), PipelineValidator::validateCombine).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.SplittableParDoComponents.PAIR_WITH_RESTRICTION), PipelineValidator::validateParDo).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.SplittableParDoComponents.SPLIT_RESTRICTION), PipelineValidator::validateParDo).put(BeamUrns.getUrn(RunnerApi.StandardPTransforms.SplittableParDoComponents.PROCESS_KEYED_ELEMENTS), PipelineValidator::validateParDo).put("beam:runner:executable_stage:v1", PipelineValidator::validateExecutableStage).build();

    public static void validate(RunnerApi.Pipeline p) {
        RunnerApi.Components components = p.getComponents();
        for (String transformId : p.getRootTransformIdsList()) {
            Preconditions.checkArgument(components.containsTransforms(transformId), "Root transform id %s is unknown", (Object)transformId);
        }
        PipelineValidator.validateComponents("pipeline", components);
    }

    private static void validateComponents(String context, RunnerApi.Components components) {
        String previousId;
        HashMap<String, String> uniqueNamesById = Maps.newHashMap();
        for (String transformId : components.getTransformsMap().keySet()) {
            RunnerApi.PTransform transform = components.getTransformsOrThrow(transformId);
            previousId = uniqueNamesById.put(transform.getUniqueName(), transformId);
            Preconditions.checkArgument(previousId == null, "%s: Transforms %s and %s both have unique_name \"%s\"", (Object)context, (Object)transformId, (Object)previousId, (Object)transform.getUniqueName());
            PipelineValidator.validateTransform(transformId, transform, components);
        }
        uniqueNamesById = Maps.newHashMap();
        for (String pcollectionId : components.getPcollectionsMap().keySet()) {
            RunnerApi.PCollection pc = components.getPcollectionsOrThrow(pcollectionId);
            Preconditions.checkArgument(!pc.getUniqueName().isEmpty(), "%s: PCollection %s does not have a unique_name set", (Object)context, (Object)pcollectionId);
            previousId = uniqueNamesById.put(pc.getUniqueName(), pcollectionId);
            Preconditions.checkArgument(previousId == null, "%s: PCollections %s and %s both have unique_name \"%s\"", (Object)context, (Object)pcollectionId, (Object)previousId, (Object)pc.getUniqueName());
            Preconditions.checkArgument(components.containsCoders(pc.getCoderId()), "%s: PCollection %s uses unknown coder %s", (Object)context, (Object)pcollectionId, (Object)pc.getCoderId());
            Preconditions.checkArgument(components.containsWindowingStrategies(pc.getWindowingStrategyId()), "%s: PCollection %s uses unknown windowing strategy %s", (Object)context, (Object)pcollectionId, (Object)pc.getWindowingStrategyId());
        }
        for (String strategyId : components.getWindowingStrategiesMap().keySet()) {
            RunnerApi.WindowingStrategy strategy = components.getWindowingStrategiesOrThrow(strategyId);
            Preconditions.checkArgument(components.containsCoders(strategy.getWindowCoderId()), "%s: WindowingStrategy %s uses unknown coder %s", (Object)context, (Object)strategyId, (Object)strategy.getWindowCoderId());
        }
        for (String coderId : components.getCodersMap().keySet()) {
            for (String componentCoderId : components.getCodersOrThrow(coderId).getComponentCoderIdsList()) {
                Preconditions.checkArgument(components.containsCoders(componentCoderId), "%s: Coder %s uses unknown component coder %s", (Object)context, (Object)coderId, (Object)componentCoderId);
            }
        }
    }

    private static void validateTransform(String id, RunnerApi.PTransform transform, RunnerApi.Components components) {
        String pcollectionId;
        for (String subtransformId : transform.getSubtransformsList()) {
            Preconditions.checkArgument(components.containsTransforms(subtransformId), "Transform %s references unknown subtransform %s", (Object)id, (Object)subtransformId);
        }
        for (String inputId : transform.getInputsMap().keySet()) {
            pcollectionId = transform.getInputsOrThrow(inputId);
            Preconditions.checkArgument(components.containsPcollections(pcollectionId), "Transform %s input %s points to unknown PCollection %s", (Object)id, (Object)inputId, (Object)pcollectionId);
        }
        for (String outputId : transform.getOutputsMap().keySet()) {
            pcollectionId = transform.getOutputsOrThrow(outputId);
            Preconditions.checkArgument(components.containsPcollections(pcollectionId), "Transform %s output %s points to unknown PCollection %s", (Object)id, (Object)outputId, (Object)pcollectionId);
        }
        String urn = transform.getSpec().getUrn();
        if (VALIDATORS.containsKey(urn)) {
            try {
                VALIDATORS.get(urn).validate(id, transform, components);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to validate transform %s", id), e);
            }
        }
    }

    private static void validateParDo(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.ParDoPayload payload = RunnerApi.ParDoPayload.parseFrom(transform.getSpec().getPayload());
        for (String sideInputId : payload.getSideInputsMap().keySet()) {
            Preconditions.checkArgument(transform.containsInputs(sideInputId), "Transform %s side input %s is not listed in the transform's inputs", (Object)id, (Object)sideInputId);
        }
        if (!payload.getRestrictionCoderId().isEmpty()) {
            Preconditions.checkArgument(components.containsCoders(payload.getRestrictionCoderId()));
        }
    }

    private static void validateAssignWindows(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.WindowIntoPayload.parseFrom(transform.getSpec().getPayload());
    }

    private static void validateTestStream(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.TestStreamPayload.parseFrom(transform.getSpec().getPayload());
    }

    private static void validateCombine(String id, RunnerApi.PTransform transform, RunnerApi.Components components) throws Exception {
        RunnerApi.CombinePayload payload = RunnerApi.CombinePayload.parseFrom(transform.getSpec().getPayload());
        Preconditions.checkArgument(components.containsCoders(payload.getAccumulatorCoderId()), "Transform %s uses unknown accumulator coder id %s", (Object)payload.getAccumulatorCoderId());
    }

    private static void validateExecutableStage(String id, RunnerApi.PTransform transform, RunnerApi.Components outerComponents) throws Exception {
        RunnerApi.ExecutableStagePayload payload = RunnerApi.ExecutableStagePayload.parseFrom(transform.getSpec().getPayload());
        RunnerApi.Components components = payload.getComponents();
        Preconditions.checkArgument(transform.getInputsMap().values().contains(payload.getInput()), "ExecutableStage %s uses unknown input %s", (Object)id, (Object)payload.getInput());
        Preconditions.checkArgument(!payload.getTransformsList().isEmpty(), "ExecutableStage %s contains no transforms", (Object)id);
        for (String subtransformId : payload.getTransformsList()) {
            Preconditions.checkArgument(components.containsTransforms(subtransformId), "ExecutableStage %s uses unknown transform %s", (Object)id, (Object)subtransformId);
        }
        for (String outputId : payload.getOutputsList()) {
            Preconditions.checkArgument(components.containsPcollections(outputId), "ExecutableStage %s uses unknown output %s", (Object)id, (Object)outputId);
        }
        PipelineValidator.validateComponents("ExecutableStage " + id, components);
    }

    @FunctionalInterface
    private static interface TransformValidator {
        public void validate(String var1, RunnerApi.PTransform var2, RunnerApi.Components var3) throws Exception;
    }
}

