/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.core.metrics;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.apache.beam.model.pipeline.v1.MetricsApi;

public class SpecMonitoringInfoValidator {
    protected final MetricsApi.MonitoringInfoSpec[] specs = (MetricsApi.MonitoringInfoSpec[])Arrays.stream(MetricsApi.MonitoringInfoSpecs.Enum.values()).filter(x -> !x.name().equals("UNRECOGNIZED")).map(x -> x.getValueDescriptor().getOptions().getExtension(MetricsApi.monitoringInfoSpec)).toArray(MetricsApi.MonitoringInfoSpec[]::new);

    public Optional<String> validate(MetricsApi.MonitoringInfo monitoringInfo) {
        MetricsApi.MonitoringInfoSpec spec = null;
        for (MetricsApi.MonitoringInfoSpec specIterator : this.specs) {
            if (!monitoringInfo.getUrn().startsWith(specIterator.getUrn())) continue;
            spec = specIterator;
            break;
        }
        if (spec == null) {
            return Optional.empty();
        }
        if (!monitoringInfo.getType().equals(spec.getTypeUrn())) {
            return Optional.of(String.format("Monitoring info with urn: %s should have type: %s, received %s", monitoringInfo.getUrn(), spec.getTypeUrn(), monitoringInfo.getType()));
        }
        HashSet<String> requiredLabels = new HashSet<String>(spec.getRequiredLabelsList());
        if (!monitoringInfo.getLabelsMap().keySet().containsAll(requiredLabels)) {
            return Optional.of(String.format("MonitoringInfo with urn: %s should have labels: %s, actual: %s", monitoringInfo.getUrn(), requiredLabels, monitoringInfo.getLabelsMap()));
        }
        return Optional.empty();
    }
}

