/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.BufferedElementCountingOutputStream;
import org.apache.beam.sdk.util.VarInt;
import org.apache.beam.sdk.util.common.ElementByteSizeObservableIterable;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public abstract class IterableLikeCoder<T, IterableT extends Iterable<T>>
extends StructuredCoder<IterableT> {
    private final Coder<T> elementCoder;
    private final String iterableName;

    public Coder<T> getElemCoder() {
        return this.elementCoder;
    }

    protected abstract IterableT decodeToIterable(List<T> var1);

    protected IterableLikeCoder(Coder<T> elementCoder, String iterableName) {
        Preconditions.checkArgument(elementCoder != null, "element Coder for IterableLikeCoder must not be null");
        Preconditions.checkArgument(iterableName != null, "iterable name for IterableLikeCoder must not be null");
        this.elementCoder = elementCoder;
        this.iterableName = iterableName;
    }

    @Override
    public void encode(IterableT iterable, OutputStream outStream) throws IOException, CoderException {
        if (iterable == null) {
            throw new CoderException("cannot encode a null " + this.iterableName);
        }
        DataOutputStream dataOutStream = new DataOutputStream(outStream);
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            dataOutStream.writeInt(collection.size());
            for (Object elem : collection) {
                this.elementCoder.encode(elem, dataOutStream);
            }
        } else {
            dataOutStream.writeInt(-1);
            BufferedElementCountingOutputStream countingOutputStream = new BufferedElementCountingOutputStream(dataOutStream);
            for (Object elem : iterable) {
                countingOutputStream.markElementStart();
                this.elementCoder.encode(elem, countingOutputStream);
            }
            countingOutputStream.finish();
        }
        dataOutStream.flush();
    }

    @Override
    public IterableT decode(InputStream inStream) throws IOException, CoderException {
        DataInputStream dataInStream = new DataInputStream(inStream);
        int size = dataInStream.readInt();
        if (size >= 0) {
            ArrayList<T> elements = new ArrayList<T>(size);
            for (int i = 0; i < size; ++i) {
                elements.add(this.elementCoder.decode(dataInStream));
            }
            return this.decodeToIterable(elements);
        }
        ArrayList<T> elements = new ArrayList<T>();
        long count = VarInt.decodeLong(dataInStream);
        while (count > 0L) {
            elements.add(this.elementCoder.decode(dataInStream));
            if (--count != 0L) continue;
            count = VarInt.decodeLong(dataInStream);
        }
        return this.decodeToIterable(elements);
    }

    @Override
    public List<? extends Coder<?>> getCoderArguments() {
        return Arrays.asList(this.elementCoder);
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        throw new Coder.NonDeterministicException(this, "IterableLikeCoder can not guarantee deterministic ordering.");
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(IterableT iterable) {
        return iterable instanceof ElementByteSizeObservableIterable;
    }

    @Override
    public void registerByteSizeObserver(IterableT iterable, ElementByteSizeObserver observer) throws Exception {
        if (iterable == null) {
            throw new CoderException("cannot encode a null Iterable");
        }
        if (iterable instanceof ElementByteSizeObservableIterable) {
            observer.setLazy();
            ElementByteSizeObservableIterable observableIterable = (ElementByteSizeObservableIterable)iterable;
            observableIterable.addObserver(new IteratorObserver(observer, iterable instanceof Collection));
        } else if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            observer.update(4L);
            for (Object elem : collection) {
                this.elementCoder.registerByteSizeObserver(elem, observer);
            }
        } else {
            observer.update(4L);
            long count = 0L;
            for (Object elem : iterable) {
                ++count;
                this.elementCoder.registerByteSizeObserver(elem, observer);
            }
            if (count > 0L) {
                observer.update(VarInt.getLength(count));
            }
            observer.update(1L);
        }
    }

    private static class IteratorObserver
    implements Observer {
        private final ElementByteSizeObserver outerObserver;
        private final boolean countable;

        public IteratorObserver(ElementByteSizeObserver outerObserver, boolean countable) {
            this.outerObserver = outerObserver;
            this.countable = countable;
            if (countable) {
                outerObserver.update(4L);
            } else {
                outerObserver.update(5L);
            }
        }

        @Override
        public void update(Observable obs, Object obj) {
            if (!(obj instanceof Long)) {
                throw new AssertionError((Object)"unexpected parameter object");
            }
            if (this.countable) {
                this.outerObserver.update(obs, obj);
            } else {
                this.outerObserver.update(obs, 1L + (Long)obj);
            }
        }
    }
}

