/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.BigDecimalCoder;
import org.apache.beam.sdk.coders.BigEndianShortCoder;
import org.apache.beam.sdk.coders.BooleanCoder;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.ByteCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.DoubleCoder;
import org.apache.beam.sdk.coders.FloatCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.RowCoderGenerator;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.VarIntCoder;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;

@Experimental
public class RowCoder
extends CustomCoder<Row> {
    static final ImmutableMap<Schema.TypeName, Coder> CODER_MAP = ImmutableMap.builder().put(Schema.TypeName.BYTE, ByteCoder.of()).put(Schema.TypeName.BYTES, (ByteCoder)((Object)ByteArrayCoder.of())).put(Schema.TypeName.INT16, (ByteCoder)((Object)BigEndianShortCoder.of())).put(Schema.TypeName.INT32, (ByteCoder)((Object)VarIntCoder.of())).put(Schema.TypeName.INT64, (ByteCoder)((Object)VarLongCoder.of())).put(Schema.TypeName.DECIMAL, (ByteCoder)((Object)BigDecimalCoder.of())).put(Schema.TypeName.FLOAT, (ByteCoder)((Object)FloatCoder.of())).put(Schema.TypeName.DOUBLE, (ByteCoder)((Object)DoubleCoder.of())).put(Schema.TypeName.STRING, (ByteCoder)((Object)StringUtf8Coder.of())).put(Schema.TypeName.DATETIME, (ByteCoder)((Object)InstantCoder.of())).put(Schema.TypeName.BOOLEAN, (ByteCoder)((Object)BooleanCoder.of())).build();
    private static final ImmutableMap<Schema.TypeName, Integer> ESTIMATED_FIELD_SIZES = ImmutableMap.builder().put(Schema.TypeName.BYTE, 1).put(Schema.TypeName.INT16, 2).put(Schema.TypeName.INT32, 4).put(Schema.TypeName.INT64, 8).put(Schema.TypeName.FLOAT, 4).put(Schema.TypeName.DOUBLE, 8).put(Schema.TypeName.DECIMAL, 32).put(Schema.TypeName.BOOLEAN, 1).put(Schema.TypeName.DATETIME, 8).build();
    private final Schema schema;
    private final UUID id;
    @Nullable
    private transient Coder<Row> delegateCoder = null;

    public static RowCoder of(Schema schema) {
        UUID id = schema.getUUID() == null ? UUID.randomUUID() : schema.getUUID();
        return new RowCoder(schema, id);
    }

    private RowCoder(Schema schema, UUID id) {
        if (schema.getUUID() != null) {
            Preconditions.checkArgument(schema.getUUID().equals(id), "Schema has a UUID that doesn't match argument to constructor. %s v.s. %s", (Object)schema.getUUID(), (Object)id);
        } else {
            schema = SerializableUtils.clone(schema);
            schema.setUUID(id);
        }
        this.schema = schema;
        this.id = id;
    }

    private Coder<Row> getDelegateCoder() {
        if (this.delegateCoder == null) {
            this.delegateCoder = RowCoderGenerator.generate(this.schema, this.id);
        }
        return this.delegateCoder;
    }

    @Override
    public void encode(Row value, OutputStream outStream) throws IOException {
        this.getDelegateCoder().encode(value, outStream);
    }

    @Override
    public Row decode(InputStream inStream) throws IOException {
        return this.getDelegateCoder().decode(inStream);
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void verifyDeterministic() throws Coder.NonDeterministicException {
        this.verifyDeterministic(this.schema);
    }

    private void verifyDeterministic(Schema schema) throws Coder.NonDeterministicException {
        List<Coder<?>> coders = schema.getFields().stream().map(Schema.Field::getType).map(RowCoder::coderForFieldType).collect(Collectors.toList());
        Coder.verifyDeterministic(this, "All fields must have deterministic encoding", coders);
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    public static <T> Coder<T> coderForFieldType(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ROW: {
                return RowCoder.of(fieldType.getRowSchema());
            }
            case ARRAY: {
                return ListCoder.of(RowCoder.coderForFieldType(fieldType.getCollectionElementType()));
            }
            case MAP: {
                return MapCoder.of(RowCoder.coderForFieldType(fieldType.getMapKeyType()), RowCoder.coderForFieldType(fieldType.getMapValueType()));
            }
        }
        return CODER_MAP.get((Object)fieldType.getTypeName());
    }

    public static long estimatedSizeBytes(Row row) {
        Schema schema = row.getSchema();
        int fieldCount = schema.getFieldCount();
        int bitmapSize = ((fieldCount - 1 >> 6) + 1) * 8;
        int fieldsSize = 0;
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            fieldsSize += (int)RowCoder.estimatedSizeBytes(schema.getField(i).getType(), row.getValue(i));
        }
        return (long)bitmapSize + (long)fieldsSize;
    }

    private static long estimatedSizeBytes(Schema.FieldType typeDescriptor, Object value) {
        switch (typeDescriptor.getTypeName()) {
            case LOGICAL_TYPE: {
                return RowCoder.estimatedSizeBytes(typeDescriptor.getLogicalType().getBaseType(), value);
            }
            case ROW: {
                return RowCoder.estimatedSizeBytes((Row)value);
            }
            case ARRAY: {
                List list = (List)value;
                long listSizeBytes = 0L;
                for (Object elem : list) {
                    listSizeBytes += RowCoder.estimatedSizeBytes(typeDescriptor.getCollectionElementType(), elem);
                }
                return 4L + listSizeBytes;
            }
            case BYTES: {
                byte[] bytes = (byte[])value;
                return 4L + (long)bytes.length;
            }
            case MAP: {
                Map map = (Map)value;
                long mapSizeBytes = 0L;
                for (Map.Entry elem : map.entrySet()) {
                    mapSizeBytes += typeDescriptor.getMapKeyType().getTypeName().equals((Object)Schema.TypeName.STRING) ? (long)((String)elem.getKey()).length() : (long)ESTIMATED_FIELD_SIZES.get((Object)typeDescriptor.getMapKeyType().getTypeName()).intValue();
                    mapSizeBytes += RowCoder.estimatedSizeBytes(typeDescriptor.getMapValueType(), elem.getValue());
                }
                return 4L + mapSizeBytes;
            }
            case STRING: {
                return ((String)value).length();
            }
        }
        return ESTIMATED_FIELD_SIZES.get((Object)typeDescriptor.getTypeName()).intValue();
    }
}

