/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.ByteBuddy;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.field.FieldList;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.method.MethodList;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.FieldManifestation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.Ownership;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.modifier.Visibility;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.FixedValue;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.Implementation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.repackaged.beam_sdks_java_core.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.sdk.coders.BitSetCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.RowCoder;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

public abstract class RowCoderGenerator {
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();
    private static final TypeDescription.ForLoadedType CODER_TYPE = new TypeDescription.ForLoadedType(Coder.class);
    private static final TypeDescription.ForLoadedType LIST_CODER_TYPE = new TypeDescription.ForLoadedType(ListCoder.class);
    private static final TypeDescription.ForLoadedType MAP_CODER_TYPE = new TypeDescription.ForLoadedType(MapCoder.class);
    private static final BitSetCoder NULL_LIST_CODER = BitSetCoder.of();
    private static final TypeDescription.ForLoadedType NULLABLE_CODER = new TypeDescription.ForLoadedType(NullableCoder.class);
    private static final String CODERS_FIELD_NAME = "FIELD_CODERS";
    private static final Map<Schema.TypeName, StackManipulation> CODER_MAP;
    private static Map<UUID, Coder<Row>> generatedCoders;

    public static Coder<Row> generate(Schema schema, UUID coderId) {
        Coder rowCoder = generatedCoders.get(coderId);
        if (rowCoder == null) {
            TypeDescription.Generic coderType = TypeDescription.Generic.Builder.parameterizedType(Coder.class, new Type[]{Row.class}).build();
            DynamicType.Builder<Coder> builder = BYTE_BUDDY.subclass(coderType);
            builder = RowCoderGenerator.createComponentCoders(schema, builder);
            builder = RowCoderGenerator.implementMethods(schema, builder);
            try {
                rowCoder = builder.make().load(Coder.class.getClassLoader(), ClassLoadingStrategy.Default.INJECTION).getLoaded().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException("Unable to generate coder for schema " + schema);
            }
            generatedCoders.put(coderId, rowCoder);
        }
        return rowCoder;
    }

    private static DynamicType.Builder<Coder> implementMethods(Schema schema, DynamicType.Builder<Coder> builder) {
        boolean hasNullableFields = schema.getFields().stream().map(Schema.Field::getType).anyMatch(Schema.FieldType::getNullable);
        return builder.defineMethod("getSchema", (Type)((Object)Schema.class), Visibility.PRIVATE, Ownership.STATIC).intercept(FixedValue.reference(schema)).defineMethod("hasNullableFields", Boolean.TYPE, Visibility.PRIVATE, Ownership.STATIC).intercept(FixedValue.reference(hasNullableFields)).method(ElementMatchers.named("encode")).intercept(new EncodeInstruction()).method(ElementMatchers.named("decode")).intercept(new DecodeInstruction());
    }

    private static DynamicType.Builder<Coder> createComponentCoders(Schema schema, DynamicType.Builder<Coder> builder) {
        ArrayList<StackManipulation> componentCoders = Lists.newArrayListWithCapacity(schema.getFieldCount());
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            componentCoders.add(RowCoderGenerator.getCoder(schema.getField(i).getType().withNullable(false)));
        }
        return builder.defineField(CODERS_FIELD_NAME, (Type)((Object)Coder[].class), Visibility.PRIVATE, Ownership.STATIC, FieldManifestation.FINAL).initializer((methodVisitor, implementationContext, instrumentedMethod) -> {
            StackManipulation.Compound manipulation = new StackManipulation.Compound(ArrayFactory.forType(CODER_TYPE.asGenericType()).withValues(componentCoders), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(CODERS_FIELD_NAME))).getOnly()).write());
            StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
            return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
        });
    }

    private static StackManipulation getCoder(Schema.FieldType fieldType) {
        if (Schema.TypeName.LOGICAL_TYPE.equals((Object)fieldType.getTypeName())) {
            return RowCoderGenerator.getCoder(fieldType.getLogicalType().getBaseType());
        }
        if (Schema.TypeName.ARRAY.equals((Object)fieldType.getTypeName())) {
            return RowCoderGenerator.listCoder(fieldType.getCollectionElementType());
        }
        if (Schema.TypeName.MAP.equals((Object)fieldType.getTypeName())) {
            return RowCoderGenerator.mapCoder(fieldType.getMapKeyType(), fieldType.getMapValueType());
        }
        if (Schema.TypeName.ROW.equals((Object)fieldType.getTypeName())) {
            Coder<Row> nestedCoder = RowCoderGenerator.generate(fieldType.getRowSchema(), UUID.randomUUID());
            RowCoder.of(fieldType.getRowSchema());
            return RowCoderGenerator.rowCoder(nestedCoder.getClass());
        }
        StackManipulation primitiveCoder = RowCoderGenerator.coderForPrimitiveType(fieldType.getTypeName());
        if (fieldType.getNullable().booleanValue()) {
            primitiveCoder = new StackManipulation.Compound(primitiveCoder, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)NULLABLE_CODER.getDeclaredMethods().filter(ElementMatchers.named("of"))).getOnly()));
        }
        return primitiveCoder;
    }

    private static StackManipulation listCoder(Schema.FieldType fieldType) {
        StackManipulation componentCoder = RowCoderGenerator.getCoder(fieldType);
        return new StackManipulation.Compound(componentCoder, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)LIST_CODER_TYPE.getDeclaredMethods().filter(ElementMatchers.named("of"))).getOnly()));
    }

    static StackManipulation coderForPrimitiveType(Schema.TypeName typeName) {
        return CODER_MAP.get((Object)typeName);
    }

    static StackManipulation mapCoder(Schema.FieldType keyType, Schema.FieldType valueType) {
        StackManipulation keyCoder = RowCoderGenerator.getCoder(keyType);
        StackManipulation valueCoder = RowCoderGenerator.getCoder(valueType);
        return new StackManipulation.Compound(keyCoder, valueCoder, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)MAP_CODER_TYPE.getDeclaredMethods().filter(ElementMatchers.named("of"))).getOnly()));
    }

    static StackManipulation rowCoder(Class coderClass) {
        TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(coderClass);
        return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()));
    }

    static {
        generatedCoders = Maps.newConcurrentMap();
        CODER_MAP = Maps.newHashMap();
        for (Map.Entry entry : RowCoder.CODER_MAP.entrySet()) {
            MethodInvocation.WithImplicitInvocationTargetType stackManipulation = MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(((Coder)entry.getValue()).getClass()).getDeclaredMethods().filter(ElementMatchers.named("of"))).getOnly());
            CODER_MAP.putIfAbsent((Schema.TypeName)((Object)entry.getKey()), stackManipulation);
        }
    }

    private static class DecodeInstruction
    implements Implementation {
        static final TypeDescription.ForLoadedType LOADED_TYPE = new TypeDescription.ForLoadedType(DecodeInstruction.class);

        private DecodeInstruction() {
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Compound manipulation = new StackManipulation.Compound(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)implementationContext.getInstrumentedType().getDeclaredMethods().filter(ElementMatchers.named("getSchema"))).getOnly()), FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.CODERS_FIELD_NAME))).getOnly()).read(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)LOADED_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("decodeDelegate")))).getOnly()), MethodReturn.REFERENCE);
                StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static Row decodeDelegate(Schema schema, Coder[] coders, InputStream inputStream) throws IOException {
            BitSet nullFields = NULL_LIST_CODER.decode(inputStream);
            ArrayList<Object> fieldValues = Lists.newArrayListWithCapacity(coders.length);
            for (int i = 0; i < coders.length; ++i) {
                if (nullFields.get(i)) {
                    fieldValues.add(null);
                    continue;
                }
                fieldValues.add(coders[i].decode(inputStream));
            }
            return Row.withSchema(schema).attachValues(fieldValues).build();
        }
    }

    private static class EncodeInstruction
    implements Implementation {
        static final TypeDescription.ForLoadedType LOADED_TYPE = new TypeDescription.ForLoadedType(EncodeInstruction.class);

        private EncodeInstruction() {
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                StackManipulation.Compound manipulation = new StackManipulation.Compound(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)implementationContext.getInstrumentedType().getDeclaredFields().filter(ElementMatchers.named(RowCoderGenerator.CODERS_FIELD_NAME))).getOnly()).read(), MethodVariableAccess.REFERENCE.loadFrom(1), MethodVariableAccess.REFERENCE.loadFrom(2), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)implementationContext.getInstrumentedType().getDeclaredMethods().filter(ElementMatchers.named("hasNullableFields"))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)LOADED_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("encodeDelegate")))).getOnly()), MethodReturn.VOID);
                StackManipulation.Size size = manipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), instrumentedMethod.getStackSize());
            };
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        static void encodeDelegate(Coder[] coders, Row value, OutputStream outputStream, boolean hasNullableFields) throws IOException {
            NULL_LIST_CODER.encode(EncodeInstruction.scanNullFields(value, hasNullableFields), outputStream);
            for (int idx = 0; idx < value.getFieldCount(); ++idx) {
                Object fieldValue = value.getValue(idx);
                if (value.getValue(idx) == null) continue;
                coders[idx].encode(fieldValue, outputStream);
            }
        }

        private static BitSet scanNullFields(Row row, boolean hasNullableFields) {
            BitSet nullFields = new BitSet(row.getFieldCount());
            if (hasNullableFields) {
                for (int idx = 0; idx < row.getFieldCount(); ++idx) {
                    if (row.getValue(idx) != null) continue;
                    nullFields.set(idx);
                }
            }
            return nullFields;
        }
    }
}

