/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.auth;

import com.google.auth.Credentials;
import com.google.auth.oauth2.GoogleCredentials;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.options.PipelineOptions;

public class GcpCredentialFactory
implements CredentialFactory {
    private static final List<String> SCOPES = Arrays.asList("https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/devstorage.full_control", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/datastore", "https://www.googleapis.com/auth/pubsub");
    private static final GcpCredentialFactory INSTANCE = new GcpCredentialFactory();

    public static GcpCredentialFactory fromOptions(PipelineOptions options) {
        return INSTANCE;
    }

    @Override
    public Credentials getCredential() {
        try {
            return GoogleCredentials.getApplicationDefault().createScoped(SCOPES);
        }
        catch (IOException e) {
            return null;
        }
    }
}

