/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.gcp.options;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.BackOff;
import com.google.api.client.util.Sleeper;
import com.google.api.services.cloudresourcemanager.CloudResourceManager;
import com.google.api.services.cloudresourcemanager.model.Project;
import com.google.api.services.storage.model.Bucket;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import com.google.cloud.hadoop.util.ResilientOperation;
import com.google.cloud.hadoop.util.RetryDeterminer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.security.GeneralSecurityException;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.gcp.auth.CredentialFactory;
import org.apache.beam.sdk.extensions.gcp.auth.GcpCredentialFactory;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.options.CloudResourceManagerOptions;
import org.apache.beam.sdk.extensions.gcp.options.GcsOptions;
import org.apache.beam.sdk.extensions.gcp.options.GoogleApiDebugOptions;
import org.apache.beam.sdk.extensions.gcp.storage.PathValidator;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.ExperimentalOptions;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.BackOffAdapter;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.util.Transport;
import org.apache.beam.sdk.util.gcsfs.GcsPath;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.Files;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Description(value="Options used to configure Google Cloud Platform project and credentials.")
public interface GcpOptions
extends GoogleApiDebugOptions,
PipelineOptions {
    public static final String STREAMING_ENGINE_EXPERIMENT = "enable_streaming_engine";
    @Deprecated
    public static final String WINDMILL_SERVICE_EXPERIMENT = "enable_windmill_service";

    @Description(value="Project id. Required when using Google Cloud Platform services. See https://cloud.google.com/storage/docs/projects for further details.")
    @Default.InstanceFactory(value=DefaultProjectFactory.class)
    public String getProject();

    public void setProject(String var1);

    @Description(value="GCP availability zone for running GCP operations. Default is up to the individual service.")
    public String getZone();

    public void setZone(String var1);

    @Description(value="The class of the credential factory that should be created and used to create credentials. If gcpCredential has not been set explicitly, an instance of this class will be constructed and used as a credential factory.")
    @Default.Class(value=GcpCredentialFactory.class)
    public Class<? extends CredentialFactory> getCredentialFactoryClass();

    public void setCredentialFactoryClass(Class<? extends CredentialFactory> var1);

    @JsonIgnore
    @Description(value="The credential instance that should be used to authenticate against GCP services. If no credential has been set explicitly, the default is to use the instance factory that constructs a credential based upon the currently set credentialFactoryClass.")
    @Default.InstanceFactory(value=GcpUserCredentialsFactory.class)
    public Credentials getGcpCredential();

    public void setGcpCredential(Credentials var1);

    @Description(value="If true will use Streaming Engine.  Defaults to false unless the experiments enable_streaming_engine or enable_windmill_service are set.")
    @Default.InstanceFactory(value=EnableStreamingEngineFactory.class)
    public boolean isEnableStreamingEngine();

    public void setEnableStreamingEngine(boolean var1);

    @Description(value="A GCS path for storing temporary files in GCP.")
    @Default.InstanceFactory(value=GcpTempLocationFactory.class)
    @Nullable
    public String getGcpTempLocation();

    public void setGcpTempLocation(String var1);

    @Description(value="GCP Cloud KMS key for Dataflow pipelines. Also used by gcpTempLocation as the default key for new buckets. Key format is: projects/<project>/locations/<location>/keyRings/<keyring>/cryptoKeys/<key>")
    @Nullable
    @Experimental
    public String getDataflowKmsKey();

    public void setDataflowKmsKey(String var1);

    public static class GcpTempLocationFactory
    implements DefaultValueFactory<String> {
        private static final FluentBackoff BACKOFF_FACTORY = FluentBackoff.DEFAULT.withMaxRetries(3).withInitialBackoff(Duration.millis(200L));
        static final String DEFAULT_REGION = "us-central1";
        static final Logger LOG = LoggerFactory.getLogger(GcpTempLocationFactory.class);

        @Override
        @Nullable
        public String create(PipelineOptions options) {
            String tempLocation = options.getTempLocation();
            if (Strings.isNullOrEmpty(tempLocation)) {
                tempLocation = GcpTempLocationFactory.tryCreateDefaultBucket(options, GcpTempLocationFactory.newCloudResourceManagerClient(options.as(CloudResourceManagerOptions.class)).build());
                options.setTempLocation(tempLocation);
            } else {
                try {
                    PathValidator validator = options.as(GcsOptions.class).getPathValidator();
                    validator.validateOutputFilePrefixSupported(tempLocation);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("Error constructing default value for gcpTempLocation: tempLocation is not a valid GCS path, %s. ", tempLocation), e);
                }
            }
            return tempLocation;
        }

        @VisibleForTesting
        static String tryCreateDefaultBucket(PipelineOptions options, CloudResourceManager crmClient) {
            GcsOptions gcsOptions = options.as(GcsOptions.class);
            String projectId = gcsOptions.getProject();
            Preconditions.checkArgument(!Strings.isNullOrEmpty(projectId), "--project is a required option.");
            long projectNumber = 0L;
            try {
                projectNumber = GcpTempLocationFactory.getProjectNumber(projectId, crmClient);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to verify project with ID " + projectId, e);
            }
            String region = DEFAULT_REGION;
            if (!Strings.isNullOrEmpty(gcsOptions.getZone())) {
                region = GcpTempLocationFactory.getRegionFromZone(gcsOptions.getZone());
            }
            String bucketName = "dataflow-staging-" + region + "-" + projectNumber;
            LOG.info("No tempLocation specified, attempting to use default bucket: {}", (Object)bucketName);
            Bucket bucket = new Bucket().setName(bucketName).setLocation(region).setEncryption(new Bucket.Encryption().setDefaultKmsKeyName(gcsOptions.getDataflowKmsKey()));
            try {
                gcsOptions.getGcsUtil().createBucket(projectId, bucket);
            }
            catch (FileAlreadyExistsException e) {
                LOG.debug("Bucket '{}'' already exists, verifying access.", (Object)bucketName);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable create default bucket.", e);
            }
            try {
                long owner = gcsOptions.getGcsUtil().bucketOwner(GcsPath.fromComponents(bucketName, ""));
                Preconditions.checkArgument(owner == projectNumber, "Bucket owner does not match the project from --project: %s vs. %s", owner, projectNumber);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to determine the owner of the default bucket at gs://" + bucketName, e);
            }
            return "gs://" + bucketName + "/temp/";
        }

        private static long getProjectNumber(String projectId, CloudResourceManager crmClient) throws IOException {
            return GcpTempLocationFactory.getProjectNumber(projectId, crmClient, BackOffAdapter.toGcpBackOff(BACKOFF_FACTORY.backoff()), Sleeper.DEFAULT);
        }

        private static long getProjectNumber(String projectId, CloudResourceManager crmClient, BackOff backoff, Sleeper sleeper) throws IOException {
            CloudResourceManager.Projects.Get getProject = crmClient.projects().get(projectId);
            try {
                Project project = ResilientOperation.retry(ResilientOperation.getGoogleRequestCallable(getProject), backoff, RetryDeterminer.SOCKET_ERRORS, IOException.class, sleeper);
                return project.getProjectNumber();
            }
            catch (Exception e) {
                throw new IOException("Unable to get project number", e);
            }
        }

        @VisibleForTesting
        static String getRegionFromZone(String zone) {
            String[] zoneParts = zone.split("-", -1);
            Preconditions.checkArgument(zoneParts.length >= 2, "Invalid zone provided: %s", (Object)zone);
            return zoneParts[0] + "-" + zoneParts[1];
        }

        @VisibleForTesting
        static CloudResourceManager.Builder newCloudResourceManagerClient(CloudResourceManagerOptions options) {
            Credentials credentials = options.getGcpCredential();
            if (credentials == null) {
                NullCredentialInitializer.throwNullCredentialException();
            }
            return new CloudResourceManager.Builder(Transport.getTransport(), Transport.getJsonFactory(), GcpTempLocationFactory.chainHttpRequestInitializer(credentials, new RetryHttpRequestInitializer(ImmutableList.of(Integer.valueOf(404))))).setApplicationName(options.getAppName()).setGoogleClientRequestInitializer(options.getGoogleApiTrace());
        }

        private static HttpRequestInitializer chainHttpRequestInitializer(Credentials credential, HttpRequestInitializer httpRequestInitializer) {
            if (credential == null) {
                return new ChainingHttpRequestInitializer(new NullCredentialInitializer(), httpRequestInitializer);
            }
            return new ChainingHttpRequestInitializer(new HttpCredentialsAdapter(credential), httpRequestInitializer);
        }
    }

    public static class EnableStreamingEngineFactory
    implements DefaultValueFactory<Boolean> {
        @Override
        public Boolean create(PipelineOptions options) {
            return ExperimentalOptions.hasExperiment(options, GcpOptions.STREAMING_ENGINE_EXPERIMENT) || ExperimentalOptions.hasExperiment(options, GcpOptions.WINDMILL_SERVICE_EXPERIMENT);
        }
    }

    public static class GcpUserCredentialsFactory
    implements DefaultValueFactory<Credentials> {
        @Override
        public Credentials create(PipelineOptions options) {
            GcpOptions gcpOptions = options.as(GcpOptions.class);
            try {
                CredentialFactory factory = InstanceBuilder.ofType(CredentialFactory.class).fromClass(gcpOptions.getCredentialFactoryClass()).fromFactoryMethod("fromOptions").withArg(PipelineOptions.class, options).build();
                return factory.getCredential();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException("Unable to obtain credential", e);
            }
        }
    }

    public static class DefaultProjectFactory
    implements DefaultValueFactory<String> {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultProjectFactory.class);

        @Override
        public String create(PipelineOptions options) {
            try {
                File configFile;
                if (this.getEnvironment().containsKey("CLOUDSDK_CONFIG")) {
                    configFile = new File(this.getEnvironment().get("CLOUDSDK_CONFIG"), "properties");
                } else if (DefaultProjectFactory.isWindows() && this.getEnvironment().containsKey("APPDATA")) {
                    configFile = new File(this.getEnvironment().get("APPDATA"), "gcloud/properties");
                } else {
                    configFile = new File(System.getProperty("user.home"), ".config/gcloud/configurations/config_default");
                    if (!configFile.exists()) {
                        configFile = new File(System.getProperty("user.home"), ".config/gcloud/properties");
                    }
                }
                String section = null;
                Pattern projectPattern = Pattern.compile("^project\\s*=\\s*(.*)$");
                Pattern sectionPattern = Pattern.compile("^\\[(.*)\\]$");
                for (String line : Files.readLines(configFile, StandardCharsets.UTF_8)) {
                    if ((line = line.trim()).isEmpty() || line.startsWith(";")) continue;
                    Matcher matcher = sectionPattern.matcher(line);
                    if (matcher.matches()) {
                        section = matcher.group(1);
                        continue;
                    }
                    if (section != null && !"core".equals(section) || !(matcher = projectPattern.matcher(line)).matches()) continue;
                    String project = matcher.group(1).trim();
                    LOG.info("Inferred default GCP project '{}' from gcloud. If this is the incorrect project, please cancel this Pipeline and specify the command-line argument --project.", (Object)project);
                    return project;
                }
            }
            catch (IOException expected) {
                LOG.debug("Failed to find default project.", expected);
            }
            return null;
        }

        private static boolean isWindows() {
            return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
        }

        @VisibleForTesting
        Map<String, String> getEnvironment() {
            return System.getenv();
        }
    }
}

