/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.fn.test;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.beam.vendor.grpc.v1p13p1.io.grpc.stub.CallStreamObserver;

public class TestStreams {
    public static <T> Builder<T> withOnNext(Consumer<T> onNext) {
        return new Builder(new ForwardingCallStreamObserver<T>(onNext, TestStreams.throwingErrorHandler(), TestStreams.noopRunnable(), TestStreams.alwaysTrueSupplier()));
    }

    private static Consumer<Throwable> throwingErrorHandler() {
        return item -> {
            throw new RuntimeException((Throwable)item);
        };
    }

    private static void noop() {
    }

    private static Runnable noopRunnable() {
        return () -> {};
    }

    private static void noop(Throwable t) {
    }

    private static <T> Consumer<T> noopConsumer() {
        return item -> {};
    }

    private static boolean returnTrue() {
        return true;
    }

    private static Supplier<Boolean> alwaysTrueSupplier() {
        return () -> true;
    }

    private static class ForwardingCallStreamObserver<T>
    extends CallStreamObserver<T> {
        private final Consumer<T> onNext;
        private final Supplier<Boolean> isReady;
        private final Consumer<Throwable> onError;
        private final Runnable onCompleted;

        public ForwardingCallStreamObserver(Consumer<T> onNext, Consumer<Throwable> onError, Runnable onCompleted, Supplier<Boolean> isReady) {
            this.onNext = onNext;
            this.onError = onError;
            this.onCompleted = onCompleted;
            this.isReady = isReady;
        }

        @Override
        public void onNext(T value) {
            this.onNext.accept(value);
        }

        @Override
        public void onError(Throwable t) {
            this.onError.accept(t);
        }

        @Override
        public void onCompleted() {
            this.onCompleted.run();
        }

        @Override
        public boolean isReady() {
            return this.isReady.get();
        }

        @Override
        public void setOnReadyHandler(Runnable onReadyHandler) {
        }

        @Override
        public void disableAutoInboundFlowControl() {
        }

        @Override
        public void request(int count) {
        }

        @Override
        public void setMessageCompression(boolean enable) {
        }
    }

    public static class Builder<T> {
        private final ForwardingCallStreamObserver<T> observer;

        private Builder(ForwardingCallStreamObserver<T> observer) {
            this.observer = observer;
        }

        public Builder<T> withIsReady(Supplier<Boolean> isReady) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, ((ForwardingCallStreamObserver)this.observer).onError, ((ForwardingCallStreamObserver)this.observer).onCompleted, isReady));
        }

        public Builder<T> withOnCompleted(Runnable onCompleted) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, ((ForwardingCallStreamObserver)this.observer).onError, onCompleted, ((ForwardingCallStreamObserver)this.observer).isReady));
        }

        public Builder<T> withOnError(Runnable onError) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, t -> onError.run(), ((ForwardingCallStreamObserver)this.observer).onCompleted, ((ForwardingCallStreamObserver)this.observer).isReady));
        }

        public Builder<T> withOnError(Consumer<Throwable> onError) {
            return new Builder(new ForwardingCallStreamObserver(((ForwardingCallStreamObserver)this.observer).onNext, onError, ((ForwardingCallStreamObserver)this.observer).onCompleted, ((ForwardingCallStreamObserver)this.observer).isReady));
        }

        public CallStreamObserver<T> build() {
            return this.observer;
        }
    }
}

