/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.io.FileIO;

final class AutoValue_AvroIO_ReadAll<T>
extends AvroIO.ReadAll<T> {
    private final FileIO.MatchConfiguration matchConfiguration;
    private final Class<T> recordClass;
    private final Schema schema;
    private final long desiredBundleSizeBytes;
    private final boolean inferBeamSchema;

    private AutoValue_AvroIO_ReadAll(FileIO.MatchConfiguration matchConfiguration, @Nullable Class<T> recordClass, @Nullable Schema schema, long desiredBundleSizeBytes, boolean inferBeamSchema) {
        this.matchConfiguration = matchConfiguration;
        this.recordClass = recordClass;
        this.schema = schema;
        this.desiredBundleSizeBytes = desiredBundleSizeBytes;
        this.inferBeamSchema = inferBeamSchema;
    }

    @Override
    FileIO.MatchConfiguration getMatchConfiguration() {
        return this.matchConfiguration;
    }

    @Override
    @Nullable
    Class<T> getRecordClass() {
        return this.recordClass;
    }

    @Override
    @Nullable
    Schema getSchema() {
        return this.schema;
    }

    @Override
    long getDesiredBundleSizeBytes() {
        return this.desiredBundleSizeBytes;
    }

    @Override
    boolean getInferBeamSchema() {
        return this.inferBeamSchema;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AvroIO.ReadAll) {
            AvroIO.ReadAll that = (AvroIO.ReadAll)o;
            return this.matchConfiguration.equals(that.getMatchConfiguration()) && (this.recordClass == null ? that.getRecordClass() == null : this.recordClass.equals(that.getRecordClass())) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && this.desiredBundleSizeBytes == that.getDesiredBundleSizeBytes() && this.inferBeamSchema == that.getInferBeamSchema();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.matchConfiguration.hashCode();
        h$ *= 1000003;
        h$ ^= this.recordClass == null ? 0 : this.recordClass.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.desiredBundleSizeBytes >>> 32 ^ this.desiredBundleSizeBytes);
        h$ *= 1000003;
        return h$ ^= this.inferBeamSchema ? 1231 : 1237;
    }

    @Override
    AvroIO.ReadAll.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends AvroIO.ReadAll.Builder<T> {
        private FileIO.MatchConfiguration matchConfiguration;
        private Class<T> recordClass;
        private Schema schema;
        private Long desiredBundleSizeBytes;
        private Boolean inferBeamSchema;

        Builder() {
        }

        private Builder(AvroIO.ReadAll<T> source) {
            this.matchConfiguration = source.getMatchConfiguration();
            this.recordClass = source.getRecordClass();
            this.schema = source.getSchema();
            this.desiredBundleSizeBytes = source.getDesiredBundleSizeBytes();
            this.inferBeamSchema = source.getInferBeamSchema();
        }

        @Override
        AvroIO.ReadAll.Builder<T> setMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            if (matchConfiguration == null) {
                throw new NullPointerException("Null matchConfiguration");
            }
            this.matchConfiguration = matchConfiguration;
            return this;
        }

        @Override
        AvroIO.ReadAll.Builder<T> setRecordClass(Class<T> recordClass) {
            this.recordClass = recordClass;
            return this;
        }

        @Override
        AvroIO.ReadAll.Builder<T> setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        AvroIO.ReadAll.Builder<T> setDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            this.desiredBundleSizeBytes = desiredBundleSizeBytes;
            return this;
        }

        @Override
        AvroIO.ReadAll.Builder<T> setInferBeamSchema(boolean inferBeamSchema) {
            this.inferBeamSchema = inferBeamSchema;
            return this;
        }

        @Override
        AvroIO.ReadAll<T> build() {
            String missing = "";
            if (this.matchConfiguration == null) {
                missing = missing + " matchConfiguration";
            }
            if (this.desiredBundleSizeBytes == null) {
                missing = missing + " desiredBundleSizeBytes";
            }
            if (this.inferBeamSchema == null) {
                missing = missing + " inferBeamSchema";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_AvroIO_ReadAll(this.matchConfiguration, this.recordClass, this.schema, this.desiredBundleSizeBytes, this.inferBeamSchema);
        }
    }
}

