/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.reflect.ReflectDatumWriter;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.AutoValue_AvroIO_Parse;
import org.apache.beam.sdk.io.AutoValue_AvroIO_ParseAll;
import org.apache.beam.sdk.io.AutoValue_AvroIO_Read;
import org.apache.beam.sdk.io.AutoValue_AvroIO_ReadAll;
import org.apache.beam.sdk.io.AutoValue_AvroIO_Sink;
import org.apache.beam.sdk.io.AutoValue_AvroIO_TypedWrite;
import org.apache.beam.sdk.io.AvroSink;
import org.apache.beam.sdk.io.AvroSource;
import org.apache.beam.sdk.io.AvroUtils;
import org.apache.beam.sdk.io.ConstantAvroDestination;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicAvroDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.FileBasedSource;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.io.WriteFiles;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.EmptyMatchTreatment;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.joda.time.Duration;

public class AvroIO {
    public static <T> Read<T> read(Class<T> recordClass) {
        return new AutoValue_AvroIO_Read.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.DISALLOW)).setRecordClass(recordClass).setSchema(ReflectData.get().getSchema(recordClass)).setInferBeamSchema(false).setHintMatchesManyFiles(false).build();
    }

    public static <T> ReadAll<T> readAll(Class<T> recordClass) {
        return new AutoValue_AvroIO_ReadAll.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.ALLOW_IF_WILDCARD)).setRecordClass(recordClass).setSchema(ReflectData.get().getSchema(recordClass)).setInferBeamSchema(false).setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static Read<GenericRecord> readGenericRecords(org.apache.avro.Schema schema) {
        return new AutoValue_AvroIO_Read.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.DISALLOW)).setRecordClass(GenericRecord.class).setSchema(schema).setInferBeamSchema(false).setHintMatchesManyFiles(false).build();
    }

    public static ReadAll<GenericRecord> readAllGenericRecords(org.apache.avro.Schema schema) {
        return new AutoValue_AvroIO_ReadAll.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.ALLOW_IF_WILDCARD)).setRecordClass(GenericRecord.class).setSchema(schema).setInferBeamSchema(false).setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static Read<GenericRecord> readGenericRecords(String schema) {
        return AvroIO.readGenericRecords(new Schema.Parser().parse(schema));
    }

    public static ReadAll<GenericRecord> readAllGenericRecords(String schema) {
        return AvroIO.readAllGenericRecords(new Schema.Parser().parse(schema));
    }

    public static <T> Parse<T> parseGenericRecords(SerializableFunction<GenericRecord, T> parseFn) {
        return new AutoValue_AvroIO_Parse.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.DISALLOW)).setParseFn(parseFn).setHintMatchesManyFiles(false).build();
    }

    public static <T> ParseAll<T> parseAllGenericRecords(SerializableFunction<GenericRecord, T> parseFn) {
        return new AutoValue_AvroIO_ParseAll.Builder().setMatchConfiguration(FileIO.MatchConfiguration.create(EmptyMatchTreatment.ALLOW_IF_WILDCARD)).setParseFn(parseFn).setDesiredBundleSizeBytes(0x4000000L).build();
    }

    public static <T> Write<T> write(Class<T> recordClass) {
        return new Write(AvroIO.defaultWriteBuilder().setGenericRecords(false).setSchema(ReflectData.get().getSchema(recordClass)).build());
    }

    public static Write<GenericRecord> writeGenericRecords(org.apache.avro.Schema schema) {
        return new Write<GenericRecord>(AvroIO.defaultWriteBuilder().setGenericRecords(true).setSchema(schema).build());
    }

    public static <UserT, OutputT> TypedWrite<UserT, Void, OutputT> writeCustomType() {
        return AvroIO.defaultWriteBuilder().setGenericRecords(false).build();
    }

    public static <UserT> TypedWrite<UserT, Void, GenericRecord> writeCustomTypeToGenericRecords() {
        return AvroIO.defaultWriteBuilder().setGenericRecords(true).build();
    }

    public static Write<GenericRecord> writeGenericRecords(String schema) {
        return AvroIO.writeGenericRecords(new Schema.Parser().parse(schema));
    }

    private static <UserT, OutputT> TypedWrite.Builder<UserT, Void, OutputT> defaultWriteBuilder() {
        return new AutoValue_AvroIO_TypedWrite.Builder().setFilenameSuffix(null).setShardTemplate(null).setNumShards(0).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).setMetadata(ImmutableMap.of()).setWindowedWrites(false).setNoSpilling(false);
    }

    private static <T> PCollection<T> setBeamSchema(PCollection<T> pc, Class<T> clazz, @Nullable org.apache.avro.Schema schema) {
        Schema beamSchema = org.apache.beam.sdk.schemas.utils.AvroUtils.getSchema(clazz, schema);
        if (beamSchema != null) {
            pc.setSchema(beamSchema, org.apache.beam.sdk.schemas.utils.AvroUtils.getToRowFunction(clazz, schema), org.apache.beam.sdk.schemas.utils.AvroUtils.getFromRowFunction(clazz));
        }
        return pc;
    }

    public static <UserT, OutputT> DynamicAvroDestinations<UserT, Void, OutputT> constantDestinations(FileBasedSink.FilenamePolicy filenamePolicy, org.apache.avro.Schema schema, Map<String, Object> metadata, CodecFactory codec, SerializableFunction<UserT, OutputT> formatFunction) {
        return new ConstantAvroDestination<UserT, OutputT>(filenamePolicy, schema, metadata, codec, formatFunction);
    }

    public static <ElementT> Sink<ElementT> sink(Class<ElementT> clazz) {
        return new AutoValue_AvroIO_Sink.Builder().setJsonSchema(ReflectData.get().getSchema(clazz).toString()).setMetadata(ImmutableMap.of()).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).build();
    }

    public static <ElementT> Sink<ElementT> sinkViaGenericRecords(org.apache.avro.Schema schema, RecordFormatter<ElementT> formatter) {
        return new AutoValue_AvroIO_Sink.Builder<ElementT>().setRecordFormatter(formatter).setJsonSchema(schema.toString()).setMetadata(ImmutableMap.of()).setCodec(TypedWrite.DEFAULT_SERIALIZABLE_CODEC).build();
    }

    private AvroIO() {
    }

    @AutoValue
    public static abstract class Sink<ElementT>
    implements FileIO.Sink<ElementT> {
        @Nullable
        private transient org.apache.avro.Schema schema;
        @Nullable
        private transient DataFileWriter<ElementT> reflectWriter;
        @Nullable
        private transient DataFileWriter<GenericRecord> genericWriter;

        @Nullable
        abstract RecordFormatter<ElementT> getRecordFormatter();

        @Nullable
        abstract String getJsonSchema();

        abstract Map<String, Object> getMetadata();

        abstract SerializableAvroCodecFactory getCodec();

        abstract Builder<ElementT> toBuilder();

        public Sink<ElementT> withMetadata(Map<String, Object> metadata) {
            return this.toBuilder().setMetadata(metadata).build();
        }

        public Sink<ElementT> withCodec(CodecFactory codec) {
            return this.toBuilder().setCodec(new SerializableAvroCodecFactory(codec)).build();
        }

        @Override
        public void open(WritableByteChannel channel) throws IOException {
            DataFileWriter<Object> writer;
            this.schema = new Schema.Parser().parse(this.getJsonSchema());
            if (this.getRecordFormatter() == null) {
                this.reflectWriter = new DataFileWriter(new ReflectDatumWriter(this.schema));
                writer = this.reflectWriter;
            } else {
                this.genericWriter = new DataFileWriter(new GenericDatumWriter(this.schema));
                writer = this.genericWriter;
            }
            writer.setCodec(this.getCodec().getCodec());
            for (Map.Entry<String, Object> entry : this.getMetadata().entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String) {
                    writer.setMeta(entry.getKey(), (String)v);
                    continue;
                }
                if (v instanceof Long) {
                    writer.setMeta(entry.getKey(), (Long)v);
                    continue;
                }
                if (v instanceof byte[]) {
                    writer.setMeta(entry.getKey(), (byte[])v);
                    continue;
                }
                throw new IllegalStateException("Metadata value type must be one of String, Long, or byte[]. Found " + v.getClass().getSimpleName());
            }
            writer.create(this.schema, Channels.newOutputStream(channel));
        }

        @Override
        public void write(ElementT element) throws IOException {
            if (this.getRecordFormatter() == null) {
                this.reflectWriter.append(element);
            } else {
                this.genericWriter.append(this.getRecordFormatter().formatRecord(element, this.schema));
            }
        }

        @Override
        public void flush() throws IOException {
            MoreObjects.firstNonNull(this.reflectWriter, this.genericWriter).flush();
        }

        @AutoValue.Builder
        static abstract class Builder<ElementT> {
            Builder() {
            }

            abstract Builder<ElementT> setRecordFormatter(RecordFormatter<ElementT> var1);

            abstract Builder<ElementT> setJsonSchema(String var1);

            abstract Builder<ElementT> setMetadata(Map<String, Object> var1);

            abstract Builder<ElementT> setCodec(SerializableAvroCodecFactory var1);

            abstract Sink<ElementT> build();
        }
    }

    public static interface RecordFormatter<ElementT>
    extends Serializable {
        public GenericRecord formatRecord(ElementT var1, org.apache.avro.Schema var2);
    }

    public static class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @VisibleForTesting
        TypedWrite<T, ?, T> inner;

        Write(TypedWrite<T, ?, T> inner) {
            this.inner = inner;
        }

        public Write<T> to(String outputPrefix) {
            return new Write<T>(this.inner.to(FileBasedSink.convertToFileResourceIfPossible(outputPrefix)).withFormatFunction(SerializableFunctions.identity()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write<T> to(ResourceId outputPrefix) {
            return new Write<T>(this.inner.to(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public Write<T> to(ValueProvider<String> outputPrefix) {
            return new Write<T>(this.inner.to(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write<T> toResource(ValueProvider<ResourceId> outputPrefix) {
            return new Write<T>(this.inner.toResource(outputPrefix).withFormatFunction(SerializableFunctions.identity()));
        }

        public Write<T> to(FileBasedSink.FilenamePolicy filenamePolicy) {
            return new Write<T>(this.inner.to(filenamePolicy).withFormatFunction(SerializableFunctions.identity()));
        }

        @Deprecated
        public Write<T> to(DynamicAvroDestinations<T, ?, T> dynamicDestinations) {
            return new Write<T>(this.inner.to(dynamicDestinations).withFormatFunction(null));
        }

        public Write<T> withSchema(org.apache.avro.Schema schema) {
            return new Write<T>(this.inner.withSchema(schema));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public Write<T> withTempDirectory(ValueProvider<ResourceId> tempDirectory) {
            return new Write<T>(this.inner.withTempDirectory(tempDirectory));
        }

        public Write<T> withTempDirectory(ResourceId tempDirectory) {
            return new Write<T>(this.inner.withTempDirectory(tempDirectory));
        }

        public Write<T> withShardNameTemplate(String shardTemplate) {
            return new Write<T>(this.inner.withShardNameTemplate(shardTemplate));
        }

        public Write<T> withSuffix(String filenameSuffix) {
            return new Write<T>(this.inner.withSuffix(filenameSuffix));
        }

        public Write<T> withNumShards(int numShards) {
            return new Write<T>(this.inner.withNumShards(numShards));
        }

        public Write<T> withoutSharding() {
            return new Write<T>(this.inner.withoutSharding());
        }

        public Write<T> withWindowedWrites() {
            return new Write<T>(this.inner.withWindowedWrites());
        }

        public Write<T> withCodec(CodecFactory codec) {
            return new Write<T>(this.inner.withCodec(codec));
        }

        public <DestinationT> TypedWrite<T, DestinationT, T> withOutputFilenames() {
            return this.inner;
        }

        public Write<T> withMetadata(Map<String, Object> metadata) {
            return new Write<T>(this.inner.withMetadata(metadata));
        }

        @Override
        public PDone expand(PCollection<T> input) {
            input.apply(this.inner);
            return PDone.in(input.getPipeline());
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            this.inner.populateDisplayData(builder);
        }
    }

    @AutoValue
    public static abstract class TypedWrite<UserT, DestinationT, OutputT>
    extends PTransform<PCollection<UserT>, WriteFilesResult<DestinationT>> {
        static final CodecFactory DEFAULT_CODEC = CodecFactory.snappyCodec();
        static final SerializableAvroCodecFactory DEFAULT_SERIALIZABLE_CODEC = new SerializableAvroCodecFactory(DEFAULT_CODEC);

        @Nullable
        abstract SerializableFunction<UserT, OutputT> getFormatFunction();

        @Nullable
        abstract ValueProvider<ResourceId> getFilenamePrefix();

        @Nullable
        abstract String getShardTemplate();

        @Nullable
        abstract String getFilenameSuffix();

        @Nullable
        abstract ValueProvider<ResourceId> getTempDirectory();

        abstract int getNumShards();

        abstract boolean getGenericRecords();

        @Nullable
        abstract org.apache.avro.Schema getSchema();

        abstract boolean getWindowedWrites();

        abstract boolean getNoSpilling();

        @Nullable
        abstract FileBasedSink.FilenamePolicy getFilenamePolicy();

        @Nullable
        abstract DynamicAvroDestinations<UserT, DestinationT, OutputT> getDynamicDestinations();

        abstract SerializableAvroCodecFactory getCodec();

        abstract ImmutableMap<String, Object> getMetadata();

        abstract Builder<UserT, DestinationT, OutputT> toBuilder();

        public TypedWrite<UserT, DestinationT, OutputT> to(String outputPrefix) {
            return this.to(FileBasedSink.convertToFileResourceIfPossible(outputPrefix));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT, OutputT> to(ResourceId outputPrefix) {
            return this.toResource(ValueProvider.StaticValueProvider.of(outputPrefix));
        }

        public TypedWrite<UserT, DestinationT, OutputT> to(ValueProvider<String> outputPrefix) {
            return this.toResource(ValueProvider.NestedValueProvider.of(outputPrefix, new OutputPrefixToResourceId()));
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT, OutputT> toResource(ValueProvider<ResourceId> outputPrefix) {
            return this.toBuilder().setFilenamePrefix(outputPrefix).build();
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT, OutputT> to(FileBasedSink.FilenamePolicy filenamePolicy) {
            return this.toBuilder().setFilenamePolicy(filenamePolicy).build();
        }

        @Deprecated
        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public <NewDestinationT> TypedWrite<UserT, NewDestinationT, OutputT> to(DynamicAvroDestinations<UserT, NewDestinationT, OutputT> dynamicDestinations) {
            return this.toBuilder().setDynamicDestinations(dynamicDestinations).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withSchema(org.apache.avro.Schema schema) {
            return this.toBuilder().setSchema(schema).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withFormatFunction(@Nullable SerializableFunction<UserT, OutputT> formatFunction) {
            return this.toBuilder().setFormatFunction(formatFunction).build();
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT, OutputT> withTempDirectory(ValueProvider<ResourceId> tempDirectory) {
            return this.toBuilder().setTempDirectory(tempDirectory).build();
        }

        @Experimental(value=Experimental.Kind.FILESYSTEM)
        public TypedWrite<UserT, DestinationT, OutputT> withTempDirectory(ResourceId tempDirectory) {
            return this.withTempDirectory(ValueProvider.StaticValueProvider.of(tempDirectory));
        }

        public TypedWrite<UserT, DestinationT, OutputT> withShardNameTemplate(String shardTemplate) {
            return this.toBuilder().setShardTemplate(shardTemplate).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withSuffix(String filenameSuffix) {
            return this.toBuilder().setFilenameSuffix(filenameSuffix).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withNumShards(int numShards) {
            Preconditions.checkArgument(numShards >= 0);
            return this.toBuilder().setNumShards(numShards).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withoutSharding() {
            return this.withNumShards(1).withShardNameTemplate("");
        }

        public TypedWrite<UserT, DestinationT, OutputT> withWindowedWrites() {
            return this.toBuilder().setWindowedWrites(true).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withNoSpilling() {
            return this.toBuilder().setNoSpilling(true).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withCodec(CodecFactory codec) {
            return this.toBuilder().setCodec(new SerializableAvroCodecFactory(codec)).build();
        }

        public TypedWrite<UserT, DestinationT, OutputT> withMetadata(Map<String, Object> metadata) {
            LinkedHashMap<String, String> badKeys = Maps.newLinkedHashMap();
            for (Map.Entry<String, Object> entry : metadata.entrySet()) {
                Object v = entry.getValue();
                if (v instanceof String || v instanceof Long || v instanceof byte[]) continue;
                badKeys.put(entry.getKey(), v.getClass().getSimpleName());
            }
            Preconditions.checkArgument(badKeys.isEmpty(), "Metadata value type must be one of String, Long, or byte[]. Found {}", badKeys);
            return this.toBuilder().setMetadata(ImmutableMap.copyOf(metadata)).build();
        }

        DynamicAvroDestinations<UserT, DestinationT, OutputT> resolveDynamicDestinations() {
            DynamicAvroDestinations<UserT, Object, OutputT> dynamicDestinations = this.getDynamicDestinations();
            if (dynamicDestinations == null) {
                FileBasedSink.FilenamePolicy usedFilenamePolicy = this.getFilenamePolicy();
                if (usedFilenamePolicy == null) {
                    usedFilenamePolicy = DefaultFilenamePolicy.fromStandardParameters(this.getFilenamePrefix(), this.getShardTemplate(), this.getFilenameSuffix(), this.getWindowedWrites());
                }
                dynamicDestinations = AvroIO.constantDestinations(usedFilenamePolicy, this.getSchema(), this.getMetadata(), this.getCodec().getCodec(), this.getFormatFunction());
            }
            return dynamicDestinations;
        }

        @Override
        public WriteFilesResult<DestinationT> expand(PCollection<UserT> input) {
            Preconditions.checkArgument(this.getFilenamePrefix() != null || this.getTempDirectory() != null, "Need to set either the filename prefix or the tempDirectory of a AvroIO.Write transform.");
            if (this.getFilenamePolicy() != null) {
                Preconditions.checkArgument(this.getShardTemplate() == null && this.getFilenameSuffix() == null, "shardTemplate and filenameSuffix should only be used with the default filename policy");
            }
            if (this.getDynamicDestinations() != null) {
                Preconditions.checkArgument(this.getFormatFunction() == null, "A format function should not be specified with DynamicDestinations. Use DynamicDestinations.formatRecord instead");
            } else {
                Preconditions.checkArgument(this.getSchema() != null, "Unless using DynamicDestinations, .withSchema() is required.");
            }
            ValueProvider<ResourceId> tempDirectory = this.getTempDirectory();
            if (tempDirectory == null) {
                tempDirectory = this.getFilenamePrefix();
            }
            WriteFiles<UserT, DestinationT, OutputT> write = WriteFiles.to(new AvroSink<UserT, DestinationT, OutputT>(tempDirectory, this.resolveDynamicDestinations(), this.getGenericRecords()));
            if (this.getNumShards() > 0) {
                write = write.withNumShards(this.getNumShards());
            }
            if (this.getWindowedWrites()) {
                write = write.withWindowedWrites();
            }
            if (this.getNoSpilling()) {
                write = write.withNoSpilling();
            }
            return (WriteFilesResult)input.apply("Write", write);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.resolveDynamicDestinations().populateDisplayData(builder);
            builder.addIfNotDefault(DisplayData.item("numShards", this.getNumShards()).withLabel("Maximum Output Shards"), 0).addIfNotNull(DisplayData.item("tempDirectory", this.getTempDirectory()).withLabel("Directory for temporary files"));
        }

        private static class OutputPrefixToResourceId
        implements SerializableFunction<String, ResourceId> {
            private OutputPrefixToResourceId() {
            }

            @Override
            public ResourceId apply(String input) {
                return FileBasedSink.convertToFileResourceIfPossible(input);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<UserT, DestinationT, OutputT> {
            Builder() {
            }

            abstract Builder<UserT, DestinationT, OutputT> setFormatFunction(@Nullable SerializableFunction<UserT, OutputT> var1);

            abstract Builder<UserT, DestinationT, OutputT> setFilenamePrefix(ValueProvider<ResourceId> var1);

            abstract Builder<UserT, DestinationT, OutputT> setFilenameSuffix(@Nullable String var1);

            abstract Builder<UserT, DestinationT, OutputT> setTempDirectory(ValueProvider<ResourceId> var1);

            abstract Builder<UserT, DestinationT, OutputT> setNumShards(int var1);

            abstract Builder<UserT, DestinationT, OutputT> setShardTemplate(@Nullable String var1);

            abstract Builder<UserT, DestinationT, OutputT> setGenericRecords(boolean var1);

            abstract Builder<UserT, DestinationT, OutputT> setSchema(org.apache.avro.Schema var1);

            abstract Builder<UserT, DestinationT, OutputT> setWindowedWrites(boolean var1);

            abstract Builder<UserT, DestinationT, OutputT> setNoSpilling(boolean var1);

            abstract Builder<UserT, DestinationT, OutputT> setFilenamePolicy(FileBasedSink.FilenamePolicy var1);

            abstract Builder<UserT, DestinationT, OutputT> setCodec(SerializableAvroCodecFactory var1);

            abstract Builder<UserT, DestinationT, OutputT> setMetadata(ImmutableMap<String, Object> var1);

            abstract Builder<UserT, DestinationT, OutputT> setDynamicDestinations(DynamicAvroDestinations<UserT, DestinationT, OutputT> var1);

            abstract TypedWrite<UserT, DestinationT, OutputT> build();
        }
    }

    @AutoValue
    public static abstract class ParseAll<T>
    extends PTransform<PCollection<String>, PCollection<T>> {
        abstract FileIO.MatchConfiguration getMatchConfiguration();

        abstract SerializableFunction<GenericRecord, T> getParseFn();

        @Nullable
        abstract Coder<T> getCoder();

        abstract long getDesiredBundleSizeBytes();

        abstract Builder<T> toBuilder();

        public ParseAll<T> withMatchConfiguration(FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        public ParseAll<T> withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        @Experimental(value=Experimental.Kind.SPLITTABLE_DO_FN)
        public ParseAll<T> watchForNewFiles(Duration pollInterval, Watch.Growth.TerminationCondition<String, ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        public ParseAll<T> withCoder(Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        @VisibleForTesting
        ParseAll<T> withDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        @Override
        public PCollection<T> expand(PCollection<String> input) {
            Coder coder = Parse.inferCoder(this.getCoder(), this.getParseFn(), input.getPipeline().getCoderRegistry());
            SerializableFunction<GenericRecord, T> parseFn = this.getParseFn();
            CreateParseSourceFn<T> createSource = new CreateParseSourceFn<T>(parseFn, coder);
            return (PCollection)input.apply(FileIO.matchAll().withConfiguration(this.getMatchConfiguration())).apply(FileIO.readMatches().withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT)).apply("Parse all via FileBasedSource", new ReadAllViaFileBasedSource(this.getDesiredBundleSizeBytes(), createSource, coder));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("parseFn", this.getParseFn().getClass()).withLabel("Parse function")).include("matchConfiguration", this.getMatchConfiguration());
        }

        private static class CreateParseSourceFn<T>
        implements SerializableFunction<String, FileBasedSource<T>> {
            private final SerializableFunction<GenericRecord, T> parseFn;
            private final Coder<T> coder;

            public CreateParseSourceFn(SerializableFunction<GenericRecord, T> parseFn, Coder<T> coder) {
                this.parseFn = parseFn;
                this.coder = coder;
            }

            @Override
            public FileBasedSource<T> apply(String input) {
                return AvroSource.from(input).withParseFn(this.parseFn, this.coder);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder<T> setParseFn(SerializableFunction<GenericRecord, T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setDesiredBundleSizeBytes(long var1);

            abstract ParseAll<T> build();
        }
    }

    @AutoValue
    public static abstract class Parse<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        abstract FileIO.MatchConfiguration getMatchConfiguration();

        abstract SerializableFunction<GenericRecord, T> getParseFn();

        @Nullable
        abstract Coder<T> getCoder();

        abstract boolean getHintMatchesManyFiles();

        abstract Builder<T> toBuilder();

        public Parse<T> from(String filepattern) {
            return this.from(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public Parse<T> from(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Parse<T> withMatchConfiguration(FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        public Parse<T> withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        @Experimental(value=Experimental.Kind.SPLITTABLE_DO_FN)
        public Parse<T> watchForNewFiles(Duration pollInterval, Watch.Growth.TerminationCondition<String, ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        public Parse<T> withCoder(Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public Parse<T> withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        @Override
        public PCollection<T> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), "filepattern");
            Coder<T> coder = Parse.inferCoder(this.getCoder(), this.getParseFn(), input.getPipeline().getCoderRegistry());
            if (this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles()) {
                return (PCollection)input.apply(org.apache.beam.sdk.io.Read.from(AvroSource.from(this.getFilepattern()).withParseFn(this.getParseFn(), coder)));
            }
            return (PCollection)((PCollection)input.apply("Create filepattern", Create.ofProvider(this.getFilepattern(), StringUtf8Coder.of()))).apply("Via ParseAll", AvroIO.parseAllGenericRecords(this.getParseFn()).withCoder(coder).withMatchConfiguration(this.getMatchConfiguration()));
        }

        private static <T> Coder<T> inferCoder(@Nullable Coder<T> explicitCoder, SerializableFunction<GenericRecord, T> parseFn, CoderRegistry coderRegistry) {
            if (explicitCoder != null) {
                return explicitCoder;
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(parseFn));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using withCoder().", e);
            }
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("Input File Pattern")).add(DisplayData.item("parseFn", this.getParseFn().getClass()).withLabel("Parse function")).include("matchConfiguration", this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFilepattern(ValueProvider<String> var1);

            abstract Builder<T> setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder<T> setParseFn(SerializableFunction<GenericRecord, T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setHintMatchesManyFiles(boolean var1);

            abstract Parse<T> build();
        }
    }

    private static class CreateSourceFn<T>
    implements SerializableFunction<String, FileBasedSource<T>> {
        private final Class<T> recordClass;
        private final Supplier<org.apache.avro.Schema> schemaSupplier;

        public CreateSourceFn(Class<T> recordClass, String jsonSchema) {
            this.recordClass = recordClass;
            this.schemaSupplier = AvroUtils.serializableSchemaSupplier(jsonSchema);
        }

        @Override
        public FileBasedSource<T> apply(String input) {
            return Read.createSource(ValueProvider.StaticValueProvider.of(input), EmptyMatchTreatment.DISALLOW, this.recordClass, this.schemaSupplier.get());
        }
    }

    @AutoValue
    public static abstract class ReadAll<T>
    extends PTransform<PCollection<String>, PCollection<T>> {
        abstract FileIO.MatchConfiguration getMatchConfiguration();

        @Nullable
        abstract Class<T> getRecordClass();

        @Nullable
        abstract org.apache.avro.Schema getSchema();

        abstract long getDesiredBundleSizeBytes();

        abstract boolean getInferBeamSchema();

        abstract Builder<T> toBuilder();

        public ReadAll<T> withMatchConfiguration(FileIO.MatchConfiguration configuration) {
            return this.toBuilder().setMatchConfiguration(configuration).build();
        }

        public ReadAll<T> withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        @Experimental(value=Experimental.Kind.SPLITTABLE_DO_FN)
        public ReadAll<T> watchForNewFiles(Duration pollInterval, Watch.Growth.TerminationCondition<String, ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        @VisibleForTesting
        ReadAll<T> withDesiredBundleSizeBytes(long desiredBundleSizeBytes) {
            return this.toBuilder().setDesiredBundleSizeBytes(desiredBundleSizeBytes).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public ReadAll<T> withBeamSchemas(boolean withBeamSchemas) {
            return this.toBuilder().setInferBeamSchema(withBeamSchemas).build();
        }

        @Override
        public PCollection<T> expand(PCollection<String> input) {
            Preconditions.checkNotNull(this.getSchema(), "schema");
            PCollection read = (PCollection)input.apply(FileIO.matchAll().withConfiguration(this.getMatchConfiguration())).apply(FileIO.readMatches().withDirectoryTreatment(FileIO.ReadMatches.DirectoryTreatment.PROHIBIT)).apply("Read all via FileBasedSource", new ReadAllViaFileBasedSource<T>(this.getDesiredBundleSizeBytes(), new CreateSourceFn<T>(this.getRecordClass(), this.getSchema().toString()), AvroCoder.of(this.getRecordClass(), this.getSchema())));
            return this.getInferBeamSchema() ? AvroIO.setBeamSchema(read, this.getRecordClass(), this.getSchema()) : read;
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.include("matchConfiguration", this.getMatchConfiguration());
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setSchema(org.apache.avro.Schema var1);

            abstract Builder<T> setDesiredBundleSizeBytes(long var1);

            abstract Builder<T> setInferBeamSchema(boolean var1);

            abstract ReadAll<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        abstract FileIO.MatchConfiguration getMatchConfiguration();

        @Nullable
        abstract Class<T> getRecordClass();

        @Nullable
        abstract org.apache.avro.Schema getSchema();

        abstract boolean getInferBeamSchema();

        abstract boolean getHintMatchesManyFiles();

        abstract Builder<T> toBuilder();

        public Read<T> from(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Read<T> from(String filepattern) {
            return this.from(ValueProvider.StaticValueProvider.of(filepattern));
        }

        public Read<T> withMatchConfiguration(FileIO.MatchConfiguration matchConfiguration) {
            return this.toBuilder().setMatchConfiguration(matchConfiguration).build();
        }

        public Read<T> withEmptyMatchTreatment(EmptyMatchTreatment treatment) {
            return this.withMatchConfiguration(this.getMatchConfiguration().withEmptyMatchTreatment(treatment));
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public Read<T> withBeamSchemas(boolean withBeamSchemas) {
            return this.toBuilder().setInferBeamSchema(withBeamSchemas).build();
        }

        @Experimental(value=Experimental.Kind.SPLITTABLE_DO_FN)
        public Read<T> watchForNewFiles(Duration pollInterval, Watch.Growth.TerminationCondition<String, ?> terminationCondition) {
            return this.withMatchConfiguration(this.getMatchConfiguration().continuously(pollInterval, terminationCondition));
        }

        public Read<T> withHintMatchesManyFiles() {
            return this.toBuilder().setHintMatchesManyFiles(true).build();
        }

        @Override
        public PCollection<T> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), "filepattern");
            Preconditions.checkNotNull(this.getSchema(), "schema");
            if (this.getMatchConfiguration().getWatchInterval() == null && !this.getHintMatchesManyFiles()) {
                PCollection read = (PCollection)input.apply("Read", org.apache.beam.sdk.io.Read.from(Read.createSource(this.getFilepattern(), this.getMatchConfiguration().getEmptyMatchTreatment(), this.getRecordClass(), this.getSchema())));
                return this.getInferBeamSchema() ? AvroIO.setBeamSchema(read, this.getRecordClass(), this.getSchema()) : read;
            }
            ReadAll<GenericRecord> readAll = this.getRecordClass() == GenericRecord.class ? AvroIO.readAllGenericRecords(this.getSchema()) : AvroIO.readAll(this.getRecordClass());
            readAll = readAll.withMatchConfiguration(this.getMatchConfiguration());
            return (PCollection)((PCollection)input.apply("Create filepattern", Create.ofProvider(this.getFilepattern(), StringUtf8Coder.of()))).apply("Via ReadAll", readAll);
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item("filePattern", this.getFilepattern()).withLabel("Input File Pattern")).include("matchConfiguration", this.getMatchConfiguration());
        }

        private static <T> AvroSource<T> createSource(ValueProvider<String> filepattern, EmptyMatchTreatment emptyMatchTreatment, Class<T> recordClass, org.apache.avro.Schema schema) {
            AvroSource<GenericRecord> source = AvroSource.from(filepattern).withEmptyMatchTreatment(emptyMatchTreatment);
            return recordClass == GenericRecord.class ? source.withSchema(schema) : source.withSchema(recordClass);
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFilepattern(ValueProvider<String> var1);

            abstract Builder<T> setMatchConfiguration(FileIO.MatchConfiguration var1);

            abstract Builder<T> setRecordClass(Class<T> var1);

            abstract Builder<T> setSchema(org.apache.avro.Schema var1);

            abstract Builder<T> setInferBeamSchema(boolean var1);

            abstract Builder<T> setHintMatchesManyFiles(boolean var1);

            abstract Read<T> build();
        }
    }
}

