/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.deflate.DeflateCompressorInputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.deflate.DeflateCompressorOutputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.zstandard.ZstdCompressorInputStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.compress.compressors.zstandard.ZstdCompressorOutputStream;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.ByteStreams;
import org.apache.beam.vendor.guava.v20_0.com.google.common.primitives.Ints;

public enum Compression {
    AUTO("", new String[0]){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) {
            throw new UnsupportedOperationException("Must resolve compression into a concrete value before calling readDecompressed()");
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) {
            throw new UnsupportedOperationException("AUTO is applicable only to reading files");
        }
    }
    ,
    UNCOMPRESSED("", new String[0]){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) {
            return channel;
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) {
            return channel;
        }
    }
    ,
    GZIP(".gz", new String[]{".gz"}){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) throws IOException {
            byte zero;
            int header;
            PushbackInputStream stream = new PushbackInputStream(Channels.newInputStream(channel), 2);
            byte[] headerBytes = new byte[2];
            int bytesRead = ByteStreams.read(stream, headerBytes, 0, 2);
            stream.unread(headerBytes, 0, bytesRead);
            if (bytesRead >= 2 && (header = Ints.fromBytes(zero = 0, zero, headerBytes[1], headerBytes[0])) == 35615) {
                return Channels.newChannel(new GzipCompressorInputStream(stream, true));
            }
            return Channels.newChannel(stream);
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) throws IOException {
            return Channels.newChannel(new GZIPOutputStream(Channels.newOutputStream(channel), true));
        }
    }
    ,
    BZIP2(".bz2", new String[]{".bz2"}){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) throws IOException {
            return Channels.newChannel(new BZip2CompressorInputStream(Channels.newInputStream(channel), true));
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) throws IOException {
            return Channels.newChannel(new BZip2CompressorOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    ZIP(".zip", new String[]{".zip"}){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) throws IOException {
            FullZipInputStream zip = new FullZipInputStream(Channels.newInputStream(channel));
            return Channels.newChannel(zip);
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) throws IOException {
            throw new UnsupportedOperationException("Writing ZIP files is currently unsupported");
        }
    }
    ,
    ZSTD(".zst", new String[]{".zst", ".zstd"}){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) throws IOException {
            return Channels.newChannel(new ZstdCompressorInputStream(Channels.newInputStream(channel)));
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) throws IOException {
            return Channels.newChannel(new ZstdCompressorOutputStream(Channels.newOutputStream(channel)));
        }
    }
    ,
    DEFLATE(".deflate", new String[]{".deflate", ".zlib"}){

        @Override
        public ReadableByteChannel readDecompressed(ReadableByteChannel channel) throws IOException {
            return Channels.newChannel(new DeflateCompressorInputStream(Channels.newInputStream(channel)));
        }

        @Override
        public WritableByteChannel writeCompressed(WritableByteChannel channel) throws IOException {
            return Channels.newChannel(new DeflateCompressorOutputStream(Channels.newOutputStream(channel)));
        }
    };

    private final String suggestedSuffix;
    private final ImmutableList<String> detectedSuffixes;

    private Compression(String suggestedSuffix, String ... detectedSuffixes) {
        this.suggestedSuffix = suggestedSuffix;
        this.detectedSuffixes = ImmutableList.copyOf(detectedSuffixes);
    }

    public String getSuggestedSuffix() {
        return this.suggestedSuffix;
    }

    public boolean matches(String filename) {
        for (String suffix : this.detectedSuffixes) {
            if (!filename.toLowerCase().endsWith(suffix)) continue;
            return true;
        }
        return false;
    }

    public boolean isCompressed(String filename) {
        Compression compression = this;
        if (compression == AUTO) {
            compression = Compression.detect(filename);
        }
        return compression != UNCOMPRESSED;
    }

    public static Compression detect(String filename) {
        for (Compression value : Compression.values()) {
            if (!value.matches(filename)) continue;
            return value;
        }
        return UNCOMPRESSED;
    }

    public abstract ReadableByteChannel readDecompressed(ReadableByteChannel var1) throws IOException;

    public abstract WritableByteChannel writeCompressed(WritableByteChannel var1) throws IOException;

    private static class FullZipInputStream
    extends InputStream {
        private ZipInputStream zipInputStream;
        private ZipEntry currentEntry;

        public FullZipInputStream(InputStream is) throws IOException {
            this.zipInputStream = new ZipInputStream(is);
            this.currentEntry = this.zipInputStream.getNextEntry();
        }

        @Override
        public int read() throws IOException {
            int result = this.zipInputStream.read();
            while (result == -1) {
                this.currentEntry = this.zipInputStream.getNextEntry();
                if (this.currentEntry == null) {
                    return -1;
                }
                result = this.zipInputStream.read();
            }
            return result;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int result = this.zipInputStream.read(b, off, len);
            while (result == -1) {
                this.currentEntry = this.zipInputStream.getNextEntry();
                if (this.currentEntry == null) {
                    return -1;
                }
                result = this.zipInputStream.read(b, off, len);
            }
            return result;
        }
    }
}

