/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.file.CodecFactory;
import org.apache.beam.sdk.io.AvroIO;
import org.apache.beam.sdk.io.DynamicAvroDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.SerializableAvroCodecFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Suppliers;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.BaseEncoding;

class ConstantAvroDestination<UserT, OutputT>
extends DynamicAvroDestinations<UserT, Void, OutputT> {
    private static final int METADATA_BYTES_MAX_LENGTH = 40;
    private final FileBasedSink.FilenamePolicy filenamePolicy;
    private final Supplier<Schema> schema;
    private final Map<String, Object> metadata;
    private final SerializableAvroCodecFactory codec;
    private final SerializableFunction<UserT, OutputT> formatFunction;

    public ConstantAvroDestination(FileBasedSink.FilenamePolicy filenamePolicy, Schema schema, Map<String, Object> metadata, CodecFactory codec, SerializableFunction<UserT, OutputT> formatFunction) {
        this.filenamePolicy = filenamePolicy;
        this.schema = Suppliers.compose(new SchemaFunction(), Suppliers.ofInstance(schema.toString()));
        this.metadata = metadata;
        this.codec = new SerializableAvroCodecFactory(codec);
        this.formatFunction = formatFunction;
    }

    @Override
    public OutputT formatRecord(UserT record) {
        return this.formatFunction.apply(record);
    }

    @Override
    @Nullable
    public Void getDestination(UserT element) {
        return null;
    }

    @Override
    @Nullable
    public Void getDefaultDestination() {
        return null;
    }

    @Override
    public FileBasedSink.FilenamePolicy getFilenamePolicy(Void destination) {
        return this.filenamePolicy;
    }

    @Override
    public Schema getSchema(Void destination) {
        return this.schema.get();
    }

    @Override
    public Map<String, Object> getMetadata(Void destination) {
        return this.metadata;
    }

    @Override
    public CodecFactory getCodec(Void destination) {
        return this.codec.getCodec();
    }

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        this.filenamePolicy.populateDisplayData(builder);
        builder.add(DisplayData.item("schema", this.schema.get().toString()).withLabel("Record Schema"));
        builder.addIfNotDefault(DisplayData.item("codec", this.codec.getCodec().toString()).withLabel("Avro Compression Codec"), AvroIO.TypedWrite.DEFAULT_SERIALIZABLE_CODEC.toString());
        builder.include("Metadata", new Metadata());
    }

    private class Metadata
    implements HasDisplayData {
        private Metadata() {
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            for (Map.Entry entry : ConstantAvroDestination.this.metadata.entrySet()) {
                DisplayData.Type type = DisplayData.inferType(entry.getValue());
                if (type != null) {
                    builder.add(DisplayData.item((String)entry.getKey(), type, entry.getValue()));
                    continue;
                }
                String base64 = BaseEncoding.base64().encode((byte[])entry.getValue());
                String repr = base64.length() <= 40 ? base64 : base64.substring(0, 40) + "...";
                builder.add(DisplayData.item((String)entry.getKey(), repr));
            }
        }
    }

    private static class SchemaFunction
    implements Serializable,
    Function<String, Schema> {
        private SchemaFunction() {
        }

        @Override
        @Nullable
        public Schema apply(@Nullable String input) {
            return new Schema.Parser().parse(input);
        }
    }
}

