/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.FileSystems;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.beam.repackaged.beam_sdks_java_core.org.apache.commons.lang3.SystemUtils;
import org.apache.beam.sdk.io.FileSystem;
import org.apache.beam.sdk.io.LocalResourceId;
import org.apache.beam.sdk.io.fs.CreateOptions;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Predicates;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.io.Files;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LocalFileSystem
extends FileSystem<LocalResourceId> {
    private static final Logger LOG = LoggerFactory.getLogger(LocalFileSystem.class);

    LocalFileSystem() {
    }

    @Override
    protected List<MatchResult> match(List<String> specs) throws IOException {
        ImmutableList.Builder ret = ImmutableList.builder();
        for (String spec : specs) {
            ret.add(this.matchOne(spec));
        }
        return ret.build();
    }

    @Override
    protected WritableByteChannel create(LocalResourceId resourceId, CreateOptions createOptions) throws IOException {
        LOG.debug("creating file {}", (Object)resourceId);
        File absoluteFile = resourceId.getPath().toFile().getAbsoluteFile();
        if (!(absoluteFile.getParentFile() == null || absoluteFile.getParentFile().exists() || absoluteFile.getParentFile().mkdirs() || absoluteFile.getParentFile().exists())) {
            throw new IOException("Unable to create parent directories for '" + resourceId + "'");
        }
        return Channels.newChannel(new BufferedOutputStream(new FileOutputStream(absoluteFile)));
    }

    @Override
    protected ReadableByteChannel open(LocalResourceId resourceId) throws IOException {
        LOG.debug("opening file {}", (Object)resourceId);
        FileInputStream inputStream = new FileInputStream(resourceId.getPath().toFile());
        return inputStream.getChannel();
    }

    @Override
    protected void copy(List<LocalResourceId> srcResourceIds, List<LocalResourceId> destResourceIds) throws IOException {
        Preconditions.checkArgument(srcResourceIds.size() == destResourceIds.size(), "Number of source files %s must equal number of destination files %s", srcResourceIds.size(), destResourceIds.size());
        int numFiles = srcResourceIds.size();
        for (int i = 0; i < numFiles; ++i) {
            LocalResourceId src = srcResourceIds.get(i);
            LocalResourceId dst = destResourceIds.get(i);
            LOG.debug("Copying {} to {}", (Object)src, (Object)dst);
            File parent = dst.getCurrentDirectory().getPath().toFile();
            if (!parent.exists()) {
                Preconditions.checkArgument(parent.mkdirs() || parent.exists(), "Unable to make output directory %s in order to copy into file %s", (Object)parent, (Object)dst.getPath());
            }
            java.nio.file.Files.copy(src.getPath(), dst.getPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
        }
    }

    @Override
    protected void rename(List<LocalResourceId> srcResourceIds, List<LocalResourceId> destResourceIds) throws IOException {
        Preconditions.checkArgument(srcResourceIds.size() == destResourceIds.size(), "Number of source files %s must equal number of destination files %s", srcResourceIds.size(), destResourceIds.size());
        int numFiles = srcResourceIds.size();
        for (int i = 0; i < numFiles; ++i) {
            LocalResourceId src = srcResourceIds.get(i);
            LocalResourceId dst = destResourceIds.get(i);
            LOG.debug("Renaming {} to {}", (Object)src, (Object)dst);
            File parent = dst.getCurrentDirectory().getPath().toFile();
            if (!parent.exists()) {
                Preconditions.checkArgument(parent.mkdirs() || parent.exists(), "Unable to make output directory %s in order to move into file %s", (Object)parent, (Object)dst.getPath());
            }
            java.nio.file.Files.move(src.getPath(), dst.getPath(), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
    }

    @Override
    protected void delete(Collection<LocalResourceId> resourceIds) throws IOException {
        for (LocalResourceId resourceId : resourceIds) {
            try {
                java.nio.file.Files.delete(resourceId.getPath());
            }
            catch (NoSuchFileException e) {
                LOG.info("Ignoring failed deletion of file {} which already does not exist: {}", (Object)resourceId, (Object)e);
            }
        }
    }

    @Override
    protected LocalResourceId matchNewResource(String singleResourceSpec, boolean isDirectory) {
        Path path = Paths.get(singleResourceSpec, new String[0]);
        return LocalResourceId.fromPath(path, isDirectory);
    }

    @Override
    protected String getScheme() {
        return "file";
    }

    private MatchResult matchOne(String spec) throws IOException {
        File file;
        if (spec.toLowerCase().startsWith("file:")) {
            spec = spec.substring("file:".length());
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            List<String> prefixes = Arrays.asList("///", "/");
            for (String prefix : prefixes) {
                if (!spec.toLowerCase().startsWith(prefix)) continue;
                spec = spec.substring(prefix.length());
            }
        }
        if ((file = new File(spec)).exists()) {
            return MatchResult.create(MatchResult.Status.OK, ImmutableList.of(this.toMetadata(file)));
        }
        File parent = file.getAbsoluteFile().getParentFile();
        if (!parent.exists()) {
            return MatchResult.create(MatchResult.Status.NOT_FOUND, Collections.emptyList());
        }
        String pathToMatch = file.getAbsolutePath().replaceAll(Matcher.quoteReplacement("\\"), Matcher.quoteReplacement("\\\\"));
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pathToMatch);
        FluentIterable<File> files = Files.fileTreeTraverser().preOrderTraversal(parent);
        Iterable matchedFiles = StreamSupport.stream(files.spliterator(), false).filter(Predicates.and(Files.isFile(), input -> matcher.matches(input.toPath()))::apply).collect(Collectors.toList());
        LinkedList<MatchResult.Metadata> result = Lists.newLinkedList();
        for (File match : matchedFiles) {
            result.add(this.toMetadata(match));
        }
        if (result.isEmpty()) {
            return MatchResult.create(MatchResult.Status.NOT_FOUND, new FileNotFoundException(String.format("No files found for spec: %s.", spec)));
        }
        return MatchResult.create(MatchResult.Status.OK, result);
    }

    private MatchResult.Metadata toMetadata(File file) {
        return MatchResult.Metadata.builder().setResourceId(LocalResourceId.fromPath(file.toPath(), file.isDirectory())).setIsReadSeekEfficient(true).setSizeBytes(file.length()).setLastModifiedMillis(file.lastModified()).build();
    }
}

