/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.io.range.OffsetRangeTracker;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class OffsetBasedSource<T>
extends BoundedSource<T> {
    private final long startOffset;
    private final long endOffset;
    private final long minBundleSize;

    public OffsetBasedSource(long startOffset, long endOffset, long minBundleSize) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.minBundleSize = minBundleSize;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getMinBundleSize() {
        return this.minBundleSize;
    }

    @Override
    public long getEstimatedSizeBytes(PipelineOptions options) throws Exception {
        long trueEndOffset = this.endOffset == Long.MAX_VALUE ? this.getMaxEndOffset(options) : this.endOffset;
        return this.getBytesPerOffset() * (trueEndOffset - this.getStartOffset());
    }

    @Override
    public List<? extends OffsetBasedSource<T>> split(long desiredBundleSizeBytes, PipelineOptions options) throws Exception {
        long desiredBundleSizeOffsetUnits = Math.max(Math.max(1L, desiredBundleSizeBytes / this.getBytesPerOffset()), this.minBundleSize);
        ArrayList<OffsetBasedSource<T>> subSources = new ArrayList<OffsetBasedSource<T>>();
        for (OffsetRange range : new OffsetRange(this.startOffset, Math.min(this.endOffset, this.getMaxEndOffset(options))).split(desiredBundleSizeOffsetUnits, this.minBundleSize)) {
            subSources.add(this.createSourceForSubrange(range.getFrom(), range.getTo()));
        }
        return subSources;
    }

    @Override
    public void validate() {
        Preconditions.checkArgument(this.startOffset >= 0L, "Start offset has value %s, must be non-negative", this.startOffset);
        Preconditions.checkArgument(this.endOffset >= 0L, "End offset has value %s, must be non-negative", this.endOffset);
        Preconditions.checkArgument(this.startOffset <= this.endOffset, "Start offset %s may not be larger than end offset %s", this.startOffset, this.endOffset);
        Preconditions.checkArgument(this.minBundleSize >= 0L, "minBundleSize has value %s, must be non-negative", this.minBundleSize);
    }

    public String toString() {
        return "[" + this.startOffset + ", " + this.endOffset + ")";
    }

    public long getBytesPerOffset() {
        return 1L;
    }

    public abstract long getMaxEndOffset(PipelineOptions var1) throws Exception;

    public abstract OffsetBasedSource<T> createSourceForSubrange(long var1, long var3);

    @Override
    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.addIfNotDefault(DisplayData.item("minBundleSize", this.minBundleSize).withLabel("Minimum Bundle Size"), 1L).addIfNotDefault(DisplayData.item("startOffset", this.startOffset).withLabel("Start Read Offset"), 0L).addIfNotDefault(DisplayData.item("endOffset", this.endOffset).withLabel("End Read Offset"), Long.MAX_VALUE);
    }

    public static abstract class OffsetBasedReader<T>
    extends BoundedSource.BoundedReader<T> {
        private static final Logger LOG = LoggerFactory.getLogger(OffsetBasedReader.class);
        private OffsetBasedSource<T> source;
        private final OffsetRangeTracker rangeTracker;

        public final boolean isDone() {
            return this.rangeTracker.isDone();
        }

        public final boolean isStarted() {
            return this.rangeTracker.isStarted();
        }

        public OffsetBasedReader(OffsetBasedSource<T> source) {
            this.source = source;
            this.rangeTracker = new OffsetRangeTracker(source.getStartOffset(), source.getEndOffset());
        }

        protected abstract long getCurrentOffset() throws NoSuchElementException;

        protected boolean isAtSplitPoint() throws NoSuchElementException {
            return true;
        }

        @Override
        public final boolean start() throws IOException {
            return this.startImpl() && this.rangeTracker.tryReturnRecordAt(this.isAtSplitPoint(), this.getCurrentOffset()) || this.rangeTracker.markDone();
        }

        @Override
        public final boolean advance() throws IOException {
            return this.advanceImpl() && this.rangeTracker.tryReturnRecordAt(this.isAtSplitPoint(), this.getCurrentOffset()) || this.rangeTracker.markDone();
        }

        protected abstract boolean startImpl() throws IOException;

        protected abstract boolean advanceImpl() throws IOException;

        @Override
        public synchronized OffsetBasedSource<T> getCurrentSource() {
            return this.source;
        }

        @Override
        public Double getFractionConsumed() {
            return this.rangeTracker.getFractionConsumed();
        }

        @Override
        public long getSplitPointsConsumed() {
            return this.rangeTracker.getSplitPointsProcessed();
        }

        @Override
        public long getSplitPointsRemaining() {
            if (this.isDone()) {
                return 0L;
            }
            if (!this.isStarted()) {
                return -1L;
            }
            if (!this.allowsDynamicSplitting()) {
                return 1L;
            }
            if (this.getCurrentOffset() >= this.rangeTracker.getStopPosition() - 1L) {
                return 1L;
            }
            return super.getSplitPointsRemaining();
        }

        public boolean allowsDynamicSplitting() {
            return true;
        }

        @Override
        public final synchronized OffsetBasedSource<T> splitAtFraction(double fraction) {
            if (!this.allowsDynamicSplitting()) {
                return null;
            }
            if (this.rangeTracker.getStopPosition() == Long.MAX_VALUE) {
                LOG.debug("Refusing to split unbounded OffsetBasedReader {} at fraction {}", (Object)this.rangeTracker, (Object)fraction);
                return null;
            }
            long splitOffset = this.rangeTracker.getPositionForFractionConsumed(fraction);
            LOG.debug("Proposing to split OffsetBasedReader {} at fraction {} (offset {})", this.rangeTracker, fraction, splitOffset);
            long start = this.source.getStartOffset();
            long end = this.source.getEndOffset();
            OffsetBasedSource<T> primary = this.source.createSourceForSubrange(start, splitOffset);
            OffsetBasedSource<T> residual = this.source.createSourceForSubrange(splitOffset, end);
            if (!this.rangeTracker.trySplitAtPosition(splitOffset)) {
                return null;
            }
            this.source = primary;
            return residual;
        }
    }
}

