/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import javax.annotation.Nullable;
import org.apache.beam.sdk.io.BoundedReadFromUnboundedSource;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.NameUtils;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.joda.time.Duration;

public class Read {
    public static <T> Bounded<T> from(BoundedSource<T> source) {
        return new Bounded(null, source);
    }

    public static <T> Unbounded<T> from(UnboundedSource<T, ?> source) {
        return new Unbounded(null, source);
    }

    public static class Unbounded<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final UnboundedSource<T, ?> source;

        private Unbounded(@Nullable String name, UnboundedSource<T, ?> source) {
            super(name);
            this.source = SerializableUtils.ensureSerializable(source);
        }

        public BoundedReadFromUnboundedSource<T> withMaxNumRecords(long maxNumRecords) {
            return new BoundedReadFromUnboundedSource<T>(this.source, maxNumRecords, null);
        }

        public BoundedReadFromUnboundedSource<T> withMaxReadTime(Duration maxReadTime) {
            return new BoundedReadFromUnboundedSource<T>(this.source, Long.MAX_VALUE, maxReadTime);
        }

        @Override
        public final PCollection<T> expand(PBegin input) {
            this.source.validate();
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.UNBOUNDED, this.source.getOutputCoder());
        }

        public UnboundedSource<T, ?> getSource() {
            return this.source;
        }

        @Override
        public String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", this.source);
        }
    }

    public static class Bounded<T>
    extends PTransform<PBegin, PCollection<T>> {
        private final BoundedSource<T> source;

        private Bounded(@Nullable String name, BoundedSource<T> source) {
            super(name);
            this.source = SerializableUtils.ensureSerializable(source);
        }

        @Override
        public final PCollection<T> expand(PBegin input) {
            this.source.validate();
            return PCollection.createPrimitiveOutputInternal(input.getPipeline(), WindowingStrategy.globalDefault(), PCollection.IsBounded.BOUNDED, this.source.getOutputCoder());
        }

        public BoundedSource<T> getSource() {
            return this.source;
        }

        @Override
        public String getKindString() {
            return String.format("Read(%s)", NameUtils.approximateSimpleName(this.source));
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item("source", this.source.getClass()).withLabel("Read Source")).include("source", this.source);
        }
    }

    public static class Builder {
        private final String name;

        private Builder(String name) {
            this.name = name;
        }

        public <T> Bounded<T> from(BoundedSource<T> source) {
            return new Bounded(this.name, source);
        }

        public <T> Unbounded<T> from(UnboundedSource<T, ?> source) {
            return new Unbounded(this.name, source);
        }
    }
}

