/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.avro.file.CodecFactory;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

class SerializableAvroCodecFactory
implements Externalizable {
    private static final long serialVersionUID = 7445324844109564303L;
    private static final List<String> noOptAvroCodecs = Arrays.asList("null", "snappy", "bzip2");
    private static final Pattern deflatePattern = Pattern.compile("deflate-(?<level>-?\\d)");
    private static final Pattern xzPattern = Pattern.compile("xz-(?<level>\\d)");
    @Nullable
    private CodecFactory codecFactory;

    public SerializableAvroCodecFactory() {
    }

    public SerializableAvroCodecFactory(CodecFactory codecFactory) {
        Preconditions.checkNotNull(codecFactory, "Codec can't be null");
        Preconditions.checkState(this.checkIsSupportedCodec(codecFactory), "%s is not supported", (Object)codecFactory);
        this.codecFactory = codecFactory;
    }

    private boolean checkIsSupportedCodec(CodecFactory codecFactory) {
        String codecStr = codecFactory.toString();
        return noOptAvroCodecs.contains(codecStr) || deflatePattern.matcher(codecStr).matches() || xzPattern.matcher(codecStr).matches();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.codecFactory.toString());
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String codecStr;
        switch (codecStr = in.readUTF()) {
            case "null": 
            case "snappy": 
            case "bzip2": {
                this.codecFactory = CodecFactory.fromString(codecStr);
                return;
            }
        }
        Matcher deflateMatcher = deflatePattern.matcher(codecStr);
        if (deflateMatcher.find()) {
            this.codecFactory = CodecFactory.deflateCodec(Integer.parseInt(deflateMatcher.group("level")));
            return;
        }
        Matcher xzMatcher = xzPattern.matcher(codecStr);
        if (xzMatcher.find()) {
            this.codecFactory = CodecFactory.xzCodec(Integer.parseInt(xzMatcher.group("level")));
            return;
        }
        throw new IllegalStateException(codecStr + " is not supported");
    }

    public CodecFactory getCodec() {
        return this.codecFactory;
    }

    public String toString() {
        Preconditions.checkNotNull(this.codecFactory, "Inner CodecFactory is null, please use non default constructor");
        return this.codecFactory.toString();
    }
}

