/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.fs;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.fs.MatchResult;
import org.apache.beam.sdk.io.fs.ResourceId;

final class AutoValue_MatchResult_Metadata
extends MatchResult.Metadata {
    private final ResourceId resourceId;
    private final long sizeBytes;
    private final boolean isReadSeekEfficient;
    private final long lastModifiedMillis;

    private AutoValue_MatchResult_Metadata(ResourceId resourceId, long sizeBytes, boolean isReadSeekEfficient, long lastModifiedMillis) {
        this.resourceId = resourceId;
        this.sizeBytes = sizeBytes;
        this.isReadSeekEfficient = isReadSeekEfficient;
        this.lastModifiedMillis = lastModifiedMillis;
    }

    @Override
    public ResourceId resourceId() {
        return this.resourceId;
    }

    @Override
    public long sizeBytes() {
        return this.sizeBytes;
    }

    @Override
    public boolean isReadSeekEfficient() {
        return this.isReadSeekEfficient;
    }

    @Override
    @Experimental
    public long lastModifiedMillis() {
        return this.lastModifiedMillis;
    }

    public String toString() {
        return "Metadata{resourceId=" + this.resourceId + ", sizeBytes=" + this.sizeBytes + ", isReadSeekEfficient=" + this.isReadSeekEfficient + ", lastModifiedMillis=" + this.lastModifiedMillis + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MatchResult.Metadata) {
            MatchResult.Metadata that = (MatchResult.Metadata)o;
            return this.resourceId.equals(that.resourceId()) && this.sizeBytes == that.sizeBytes() && this.isReadSeekEfficient == that.isReadSeekEfficient() && this.lastModifiedMillis == that.lastModifiedMillis();
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.resourceId.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.sizeBytes >>> 32 ^ this.sizeBytes);
        h$ *= 1000003;
        h$ ^= this.isReadSeekEfficient ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= (int)(this.lastModifiedMillis >>> 32 ^ this.lastModifiedMillis);
    }

    static final class Builder
    extends MatchResult.Metadata.Builder {
        private ResourceId resourceId;
        private Long sizeBytes;
        private Boolean isReadSeekEfficient;
        private Long lastModifiedMillis;

        Builder() {
        }

        @Override
        public MatchResult.Metadata.Builder setResourceId(ResourceId resourceId) {
            if (resourceId == null) {
                throw new NullPointerException("Null resourceId");
            }
            this.resourceId = resourceId;
            return this;
        }

        @Override
        public MatchResult.Metadata.Builder setSizeBytes(long sizeBytes) {
            this.sizeBytes = sizeBytes;
            return this;
        }

        @Override
        public MatchResult.Metadata.Builder setIsReadSeekEfficient(boolean isReadSeekEfficient) {
            this.isReadSeekEfficient = isReadSeekEfficient;
            return this;
        }

        @Override
        public MatchResult.Metadata.Builder setLastModifiedMillis(long lastModifiedMillis) {
            this.lastModifiedMillis = lastModifiedMillis;
            return this;
        }

        @Override
        public MatchResult.Metadata build() {
            String missing = "";
            if (this.resourceId == null) {
                missing = missing + " resourceId";
            }
            if (this.sizeBytes == null) {
                missing = missing + " sizeBytes";
            }
            if (this.isReadSeekEfficient == null) {
                missing = missing + " isReadSeekEfficient";
            }
            if (this.lastModifiedMillis == null) {
                missing = missing + " lastModifiedMillis";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_MatchResult_Metadata(this.resourceId, this.sizeBytes, this.isReadSeekEfficient, this.lastModifiedMillis);
        }
    }
}

