/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.transforms.splittabledofn.HasDefaultTracker;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

public class OffsetRange
implements Serializable,
HasDefaultTracker<OffsetRange, OffsetRangeTracker> {
    private final long from;
    private final long to;

    public OffsetRange(long from, long to) {
        Preconditions.checkArgument(from <= to, "Malformed range [%s, %s)", from, to);
        this.from = from;
        this.to = to;
    }

    public long getFrom() {
        return this.from;
    }

    public long getTo() {
        return this.to;
    }

    @Override
    public OffsetRangeTracker newTracker() {
        return new OffsetRangeTracker(this);
    }

    public String toString() {
        return "[" + this.from + ", " + this.to + ')';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OffsetRange that = (OffsetRange)o;
        if (this.from != that.from) {
            return false;
        }
        return this.to == that.to;
    }

    public int hashCode() {
        int result = (int)(this.from ^ this.from >>> 32);
        result = 31 * result + (int)(this.to ^ this.to >>> 32);
        return result;
    }

    public List<OffsetRange> split(long desiredNumOffsetsPerSplit, long minNumOffsetPerSplit) {
        ArrayList<OffsetRange> res = new ArrayList<OffsetRange>();
        long start = this.getFrom();
        long maxEnd = this.getTo();
        while (start < maxEnd) {
            long end = start + desiredNumOffsetsPerSplit;
            long remaining = maxEnd - (end = Math.min(end, maxEnd));
            if (remaining < desiredNumOffsetsPerSplit / 4L || remaining < minNumOffsetPerSplit) {
                end = maxEnd;
            }
            res.add(new OffsetRange(start, end));
            start = end;
        }
        return res;
    }
}

