/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.range;

import org.apache.beam.sdk.io.range.RangeTracker;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffsetRangeTracker
implements RangeTracker<Long> {
    private static final Logger LOG = LoggerFactory.getLogger(OffsetRangeTracker.class);
    private long startOffset;
    private long stopOffset;
    private long lastRecordStart = -1L;
    private long offsetOfLastSplitPoint = -1L;
    private long splitPointsSeen = 0L;
    private boolean done = false;
    public static final long OFFSET_INFINITY = Long.MAX_VALUE;

    public OffsetRangeTracker(long startOffset, long stopOffset) {
        this.startOffset = startOffset;
        this.stopOffset = stopOffset;
    }

    private OffsetRangeTracker() {
    }

    public synchronized boolean isStarted() {
        return this.offsetOfLastSplitPoint != -1L || this.done;
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized Long getStartPosition() {
        return this.startOffset;
    }

    @Override
    public synchronized Long getStopPosition() {
        return this.stopOffset;
    }

    @Override
    public boolean tryReturnRecordAt(boolean isAtSplitPoint, Long recordStart) {
        return this.tryReturnRecordAt(isAtSplitPoint, (long)recordStart);
    }

    @Override
    public synchronized boolean tryReturnRecordAt(boolean isAtSplitPoint, long recordStart) {
        if (!this.isStarted() && !isAtSplitPoint) {
            throw new IllegalStateException(String.format("The first record [starting at %d] must be at a split point", recordStart));
        }
        if (recordStart < this.startOffset) {
            throw new IllegalStateException(String.format("Trying to return record [starting at %d] which is before the start offset [%d]", recordStart, this.startOffset));
        }
        if (recordStart < this.lastRecordStart) {
            throw new IllegalStateException(String.format("Trying to return record [starting at %d] which is before the last-returned record [starting at %d]", recordStart, this.lastRecordStart));
        }
        if (this.lastRecordStart == -1L) {
            this.startOffset = recordStart;
        }
        this.lastRecordStart = recordStart;
        if (isAtSplitPoint) {
            if (recordStart == this.offsetOfLastSplitPoint) {
                throw new IllegalStateException(String.format("Record at a split point has same offset as the previous split point: previous split point at %d, current record starts at %d", this.offsetOfLastSplitPoint, recordStart));
            }
            if (recordStart >= this.stopOffset) {
                this.done = true;
                return false;
            }
            this.offsetOfLastSplitPoint = recordStart;
            ++this.splitPointsSeen;
        }
        return true;
    }

    @Override
    public boolean trySplitAtPosition(Long splitOffset) {
        return this.trySplitAtPosition((long)splitOffset);
    }

    @Override
    public synchronized boolean trySplitAtPosition(long splitOffset) {
        if (this.stopOffset == Long.MAX_VALUE) {
            LOG.debug("Refusing to split {} at {}: stop position unspecified", (Object)this, (Object)splitOffset);
            return false;
        }
        if (!this.isStarted()) {
            LOG.debug("Refusing to split {} at {}: unstarted", (Object)this, (Object)splitOffset);
            return false;
        }
        if (splitOffset <= this.lastRecordStart) {
            LOG.debug("Refusing to split {} at {}: already past proposed split position", (Object)this, (Object)splitOffset);
            return false;
        }
        if (splitOffset < this.startOffset || splitOffset >= this.stopOffset) {
            LOG.debug("Refusing to split {} at {}: proposed split position out of range", (Object)this, (Object)splitOffset);
            return false;
        }
        LOG.debug("Agreeing to split {} at {}", (Object)this, (Object)splitOffset);
        this.stopOffset = splitOffset;
        return true;
    }

    public synchronized long getPositionForFractionConsumed(double fraction) {
        if (this.stopOffset == Long.MAX_VALUE) {
            throw new IllegalArgumentException("getPositionForFractionConsumed is not applicable to an unbounded range: " + this);
        }
        return (long)Math.floor((double)this.startOffset + fraction * (double)(this.stopOffset - this.startOffset));
    }

    @Override
    public synchronized double getFractionConsumed() {
        if (!this.isStarted()) {
            return 0.0;
        }
        if (this.isDone()) {
            return 1.0;
        }
        if (this.stopOffset == Long.MAX_VALUE) {
            return 0.0;
        }
        if (this.lastRecordStart >= this.stopOffset) {
            return 1.0;
        }
        return Math.min(1.0, 1.0 * (double)(this.lastRecordStart - this.startOffset) / (double)(this.stopOffset - this.startOffset));
    }

    public synchronized long getSplitPointsProcessed() {
        if (!this.isStarted()) {
            return 0L;
        }
        if (this.isDone()) {
            return this.splitPointsSeen;
        }
        Preconditions.checkState(this.splitPointsSeen > 0L, "A started rangeTracker should have seen > 0 split points (is %s)", this.splitPointsSeen);
        return this.splitPointsSeen - 1L;
    }

    public synchronized boolean markDone() {
        this.done = true;
        return false;
    }

    public synchronized String toString() {
        String stopString;
        String string = stopString = this.stopOffset == Long.MAX_VALUE ? "infinity" : String.valueOf(this.stopOffset);
        if (this.lastRecordStart >= 0L) {
            return String.format("<at [starting at %d] of offset range [%d, %s)>", this.lastRecordStart, this.startOffset, stopString);
        }
        return String.format("<unstarted in offset range [%d, %s)>", this.startOffset, stopString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    OffsetRangeTracker copy() {
        OffsetRangeTracker offsetRangeTracker = this;
        synchronized (offsetRangeTracker) {
            OffsetRangeTracker res;
            OffsetRangeTracker offsetRangeTracker2 = res = new OffsetRangeTracker();
            synchronized (offsetRangeTracker2) {
                res.startOffset = this.startOffset;
                res.stopOffset = this.stopOffset;
                res.offsetOfLastSplitPoint = this.offsetOfLastSplitPoint;
                res.lastRecordStart = this.lastRecordStart;
                res.done = this.done;
                res.splitPointsSeen = this.splitPointsSeen;
            }
            return res;
        }
    }
}

