/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricName;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;

@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class MetricName
implements Serializable {
    public abstract String getNamespace();

    @Deprecated
    public String namespace() {
        return this.getNamespace();
    }

    public abstract String getName();

    public String toString() {
        return String.format("%s:%s", this.getNamespace(), this.getName());
    }

    @Deprecated
    public String name() {
        return this.getName();
    }

    public static MetricName named(String namespace, String name) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(namespace), "Metric namespace must be non-empty");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Metric name must be non-empty");
        return new AutoValue_MetricName(namespace, name);
    }

    public static MetricName named(Class<?> namespace, String name) {
        Preconditions.checkArgument(namespace != null, "Metric namespace must be non-null");
        Preconditions.checkArgument(!Strings.isNullOrEmpty(name), "Metric name must be non-empty");
        return new AutoValue_MetricName(namespace.getName(), name);
    }
}

