/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricNameFilter;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@Experimental(value=Experimental.Kind.METRICS)
@AutoValue
public abstract class MetricNameFilter {
    public abstract String getNamespace();

    @Nullable
    public abstract String getName();

    public static MetricNameFilter inNamespace(String namespace) {
        return new AutoValue_MetricNameFilter(namespace, null);
    }

    public static MetricNameFilter inNamespace(Class<?> namespace) {
        return new AutoValue_MetricNameFilter(namespace.getName(), null);
    }

    public static MetricNameFilter named(String namespace, String name) {
        Preconditions.checkNotNull(name, "Must specify a name");
        return new AutoValue_MetricNameFilter(namespace, name);
    }

    public static MetricNameFilter named(Class<?> namespace, String name) {
        Preconditions.checkNotNull(namespace, "Must specify a inNamespace");
        Preconditions.checkNotNull(name, "Must specify a name");
        return new AutoValue_MetricNameFilter(namespace.getName(), name);
    }
}

