/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.metrics;

import com.google.auto.value.AutoValue;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.metrics.AutoValue_MetricQueryResults;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.vendor.grpc.v1p13p1.com.google.common.collect.ImmutableList;

@AutoValue
@Experimental(value=Experimental.Kind.METRICS)
public abstract class MetricQueryResults {
    public abstract Iterable<MetricResult<Long>> getCounters();

    public abstract Iterable<MetricResult<DistributionResult>> getDistributions();

    public abstract Iterable<MetricResult<GaugeResult>> getGauges();

    static <T> void printMetrics(String type, Iterable<MetricResult<T>> metrics, StringBuilder sb) {
        ImmutableList<MetricResult<T>> metricsList = ImmutableList.copyOf(metrics);
        if (!metricsList.isEmpty()) {
            sb.append(type).append("(");
            boolean first = true;
            for (MetricResult metricResult : metricsList) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                MetricName name = metricResult.getName();
                sb.append(metricResult.getKey()).append(": ").append(metricResult.getAttempted());
                if (!metricResult.hasCommitted()) continue;
                Object committed = metricResult.getCommitted();
                sb.append(", ").append(committed);
            }
            sb.append(")");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("MetricQueryResults(");
        MetricQueryResults.printMetrics("Counters", this.getCounters(), sb);
        MetricQueryResults.printMetrics("Distributions", this.getDistributions(), sb);
        MetricQueryResults.printMetrics("Gauges", this.getGauges(), sb);
        sb.append(")");
        return sb.toString();
    }

    public static MetricQueryResults create(Iterable<MetricResult<Long>> counters, Iterable<MetricResult<DistributionResult>> distributions, Iterable<MetricResult<GaugeResult>> gauges) {
        return new AutoValue_MetricQueryResults(counters, distributions, gauges);
    }
}

