/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.Hidden;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

@Hidden
@Experimental
public interface ExperimentalOptions
extends PipelineOptions {
    @Description(value="[Experimental] Apache Beam provides a number of experimental features that can be enabled with this flag. If executing against a managed service, please contact the service owners before enabling any experiments.")
    @Nullable
    public List<String> getExperiments();

    public void setExperiments(@Nullable List<String> var1);

    public static boolean hasExperiment(PipelineOptions options, String experiment) {
        if (options == null) {
            return false;
        }
        List<String> experiments = options.as(ExperimentalOptions.class).getExperiments();
        return experiments != null && experiments.contains(experiment);
    }

    public static void addExperiment(ExperimentalOptions options, String experiment) {
        List<String> experiments = options.getExperiments();
        if (experiments == null) {
            experiments = Lists.newArrayList();
        }
        if (!experiments.contains(experiment)) {
            experiments.add(experiment);
        }
        options.setExperiments(experiments);
    }
}

