/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.Validation;

public interface PortablePipelineOptions
extends PipelineOptions {
    @Description(value="Files to stage to the artifact service and make available to workers. Files are placed on the worker's classpath. The default value is all files from the classpath.")
    public List<String> getFilesToStage();

    public void setFilesToStage(List<String> var1);

    @Description(value="Set the default environment for running user code. Currently only docker image URL are supported.")
    public String getDefaultJavaEnvironmentUrl();

    public void setDefaultJavaEnvironmentUrl(String var1);

    @Description(value="Job service endpoint to use. Should be in the form of address and port, e.g. localhost:3000")
    @Validation.Required
    public String getJobEndpoint();

    public void setJobEndpoint(String var1);

    @Description(value="Set the default environment type for running user code. Possible options are DOCKER and PROCESS.")
    public String getDefaultEnvironmentType();

    public void setDefaultEnvironmentType(String var1);

    @Description(value="Set environment configuration for running the user code.\n For DOCKER: Url for the docker image.\n For PROCESS: json of the form {\"os\": \"<OS>\", \"arch\": \"<ARCHITECTURE>\", \"command\": \"<process to execute>\", \"env\":{\"<Environment variables 1>\": \"<ENV_VAL>\"} }. All fields in the json are optional except command.")
    @Nullable
    public String getDefaultEnvironmentConfig();

    public void setDefaultEnvironmentConfig(@Nullable String var1);

    @Description(value="Sets the number of sdk worker processes that will run on each worker node. Default is 1. If 0, it will be automatically set according to the number of CPU cores on the worker.")
    @Nullable
    public Long getSdkWorkerParallelism();

    public void setSdkWorkerParallelism(@Nullable Long var1);

    @Description(value="Duration in milliseconds for environment cache within a job. 0 means no caching.")
    @Default.Integer(value=0)
    public int getEnvironmentCacheMillis();

    public void setEnvironmentCacheMillis(int var1);
}

