/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.auto.value.AutoValue;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.beam.sdk.options.AutoValue_ProxyInvocationHandler_BoundValue;
import org.apache.beam.sdk.options.AutoValue_ProxyInvocationHandler_DisplayDataValue;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.PipelineOptionSpec;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.PipelineOptionsFactory;
import org.apache.beam.sdk.options.PipelineOptionsReflector;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Defaults;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ClassToInstanceMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.HashMultimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Multimap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.MutableClassToInstanceMap;

@ThreadSafe
class ProxyInvocationHandler
implements InvocationHandler,
Serializable {
    private final int hashCode = ThreadLocalRandom.current().nextInt();
    private final Set<Class<? extends PipelineOptions>> knownInterfaces;
    private final ClassToInstanceMap<PipelineOptions> interfaceToProxyCache;
    private final Map<String, BoundValue> options;
    private final Map<String, JsonNode> jsonOptions;
    private final Map<String, String> gettersToPropertyNames;
    private final Map<String, String> settersToPropertyNames;

    ProxyInvocationHandler(Map<String, Object> options) {
        this(ProxyInvocationHandler.bindOptions(options), Maps.newHashMap());
    }

    private static Map<String, BoundValue> bindOptions(Map<String, Object> inputOptions) {
        HashMap<String, BoundValue> options = Maps.newHashMap();
        for (Map.Entry<String, Object> entry : inputOptions.entrySet()) {
            options.put(entry.getKey(), BoundValue.fromExplicitOption(entry.getValue()));
        }
        return options;
    }

    private ProxyInvocationHandler(Map<String, BoundValue> options, Map<String, JsonNode> jsonOptions) {
        this.options = options;
        this.jsonOptions = jsonOptions;
        this.knownInterfaces = new HashSet<Class<? extends PipelineOptions>>(PipelineOptionsFactory.getRegisteredOptions());
        this.gettersToPropertyNames = Maps.newHashMap();
        this.settersToPropertyNames = Maps.newHashMap();
        this.interfaceToProxyCache = MutableClassToInstanceMap.create();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        if (args == null && "toString".equals(method.getName())) {
            return this.toString();
        }
        if (args != null && args.length == 1 && "equals".equals(method.getName())) {
            return this.equals(args[0]);
        }
        if (args == null && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        if (args == null && "outputRuntimeOptions".equals(method.getName())) {
            return this.outputRuntimeOptions((PipelineOptions)proxy);
        }
        if (args != null && "as".equals(method.getName()) && args[0] instanceof Class) {
            Class clazz = (Class)args[0];
            return this.as(clazz);
        }
        if (args != null && "populateDisplayData".equals(method.getName()) && args[0] instanceof DisplayData.Builder) {
            DisplayData.Builder builder = (DisplayData.Builder)args[0];
            builder.delegate(new PipelineOptionsDisplayData());
            return Void.TYPE;
        }
        String methodName = method.getName();
        ProxyInvocationHandler proxyInvocationHandler = this;
        synchronized (proxyInvocationHandler) {
            if (this.gettersToPropertyNames.containsKey(methodName)) {
                String propertyName = this.gettersToPropertyNames.get(methodName);
                if (!this.options.containsKey(propertyName)) {
                    Object value = this.jsonOptions.containsKey(propertyName) ? this.getValueFromJson(propertyName, method) : this.getDefault((PipelineOptions)proxy, method);
                    this.options.put(propertyName, BoundValue.fromDefault(value));
                }
                return this.options.get(propertyName).getValue();
            }
            if (this.settersToPropertyNames.containsKey(methodName)) {
                this.options.put(this.settersToPropertyNames.get(methodName), BoundValue.fromExplicitOption(args[0]));
                return Void.TYPE;
            }
        }
        throw new RuntimeException("Unknown method [" + method + "] invoked with args [" + Arrays.toString(args) + "].");
    }

    public String getOptionName(Method method) {
        return this.gettersToPropertyNames.get(method.getName());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        throw new NotSerializableException("PipelineOptions objects are not serializable and should not be embedded into transforms (did you capture a PipelineOptions object in a field or in an anonymous class?). Instead, if you're using a DoFn, access PipelineOptions at runtime via ProcessContext/StartBundleContext/FinishBundleContext.getPipelineOptions(), or pre-extract necessary fields from PipelineOptions at pipeline construction time.");
    }

    synchronized <T extends PipelineOptions> T as(Class<T> iface) {
        Preconditions.checkNotNull(iface);
        Preconditions.checkArgument(iface.isInterface(), "Not an interface: %s", iface);
        if (!this.interfaceToProxyCache.containsKey(iface)) {
            PipelineOptionsFactory.Registration<T> registration = PipelineOptionsFactory.CACHE.get().validateWellFormed(iface, this.knownInterfaces);
            List<PropertyDescriptor> propertyDescriptors = registration.getPropertyDescriptors();
            Class<T> proxyClass = registration.getProxyClass();
            this.gettersToPropertyNames.putAll(ProxyInvocationHandler.generateGettersToPropertyNames(propertyDescriptors));
            this.settersToPropertyNames.putAll(ProxyInvocationHandler.generateSettersToPropertyNames(propertyDescriptors));
            this.knownInterfaces.add(iface);
            this.interfaceToProxyCache.putInstance(iface, (PipelineOptions)InstanceBuilder.ofType(proxyClass).fromClass(proxyClass).withArg(InvocationHandler.class, this).build());
        }
        return (T)((PipelineOptions)this.interfaceToProxyCache.getInstance(iface));
    }

    public boolean equals(Object obj) {
        return obj != null && (obj instanceof ProxyInvocationHandler && this == obj || Proxy.isProxyClass(obj.getClass()) && this == Proxy.getInvocationHandler(obj));
    }

    public int hashCode() {
        return this.hashCode;
    }

    public Map<String, Map<String, Object>> outputRuntimeOptions(PipelineOptions options) {
        Set<PipelineOptionSpec> optionSpecs = PipelineOptionsReflector.getOptionSpecs(this.knownInterfaces);
        HashMap<String, Map<String, Object>> properties = Maps.newHashMap();
        for (PipelineOptionSpec spec : optionSpecs) {
            Object vp;
            if (!spec.getGetterMethod().getReturnType().equals(ValueProvider.class) || ((ValueProvider)(vp = this.invoke(options, spec.getGetterMethod(), null))).isAccessible()) continue;
            HashMap<String, Type> property = Maps.newHashMap();
            property.put("type", ((ParameterizedType)spec.getGetterMethod().getGenericReturnType()).getActualTypeArguments()[0]);
            properties.put(spec.getName(), property);
        }
        return properties;
    }

    private Multimap<String, PipelineOptionSpec> buildOptionNameToSpecMap(Set<PipelineOptionSpec> props) {
        HashMultimap<String, PipelineOptionSpec> optionsMap = HashMultimap.create();
        for (PipelineOptionSpec pipelineOptionSpec : props) {
            optionsMap.put(pipelineOptionSpec.getName(), pipelineOptionSpec);
        }
        for (Map.Entry entry : optionsMap.asMap().entrySet()) {
            ArrayList specs = Lists.newArrayList((Iterable)entry.getValue());
            if (specs.size() < 2) continue;
            for (int i = 0; i < specs.size() - 1; ++i) {
                Class<? extends PipelineOptions> iface1 = ((PipelineOptionSpec)specs.get(i)).getDefiningInterface();
                for (int j = i + 1; j < specs.size(); ++j) {
                    Class<? extends PipelineOptions> iface2 = ((PipelineOptionSpec)specs.get(j)).getDefiningInterface();
                    if (iface1.isAssignableFrom(iface2)) {
                        optionsMap.remove(entry.getKey(), specs.get(i));
                        specs.remove(i);
                        --i;
                        j = specs.size();
                        continue;
                    }
                    if (!iface2.isAssignableFrom(iface1)) continue;
                    optionsMap.remove(entry.getKey(), specs.get(j));
                    specs.remove(j);
                    --j;
                }
            }
        }
        return optionsMap;
    }

    public synchronized String toString() {
        TreeMap<String, Object> sortedOptions = new TreeMap<String, Object>();
        sortedOptions.putAll(this.jsonOptions);
        for (Map.Entry<String, BoundValue> entry : this.options.entrySet()) {
            sortedOptions.put(entry.getKey(), entry.getValue().getValue());
        }
        StringBuilder b = new StringBuilder();
        b.append("Current Settings:\n");
        for (Map.Entry entry : sortedOptions.entrySet()) {
            b.append("  " + (String)entry.getKey() + ": " + entry.getValue() + "\n");
        }
        return b.toString();
    }

    private Object getValueFromJson(String propertyName, Method method) {
        try {
            JavaType type = PipelineOptionsFactory.MAPPER.getTypeFactory().constructType(method.getGenericReturnType());
            JsonNode jsonNode = this.jsonOptions.get(propertyName);
            return PipelineOptionsFactory.MAPPER.readValue(jsonNode.toString(), type);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to parse representation", e);
        }
    }

    private Object getDefault(PipelineOptions proxy, Method method) {
        Annotation annotation;
        if (method.getReturnType().equals(ValueProvider.RuntimeValueProvider.class)) {
            throw new RuntimeException(String.format("Method %s should not have return type RuntimeValueProvider, use ValueProvider instead.", method.getName()));
        }
        if (method.getReturnType().equals(ValueProvider.StaticValueProvider.class)) {
            throw new RuntimeException(String.format("Method %s should not have return type StaticValueProvider, use ValueProvider instead.", method.getName()));
        }
        Object defaultObject = null;
        Annotation[] annotationArray = method.getAnnotations();
        int n = annotationArray.length;
        for (int i = 0; i < n && (defaultObject = this.returnDefaultHelper(annotation = annotationArray[i], proxy, method)) == null; ++i) {
        }
        if (method.getReturnType().equals(ValueProvider.class)) {
            String propertyName = this.gettersToPropertyNames.get(method.getName());
            return defaultObject == null ? new ValueProvider.RuntimeValueProvider(method.getName(), propertyName, method.getDeclaringClass(), proxy.getOptionsId()) : new ValueProvider.RuntimeValueProvider<Object>(method.getName(), propertyName, method.getDeclaringClass(), defaultObject, proxy.getOptionsId());
        }
        if (defaultObject != null) {
            return defaultObject;
        }
        return Defaults.defaultValue(method.getReturnType());
    }

    @Nullable
    private Object returnDefaultHelper(Annotation annotation, PipelineOptions proxy, Method method) {
        if (annotation instanceof Default.Class) {
            return ((Default.Class)annotation).value();
        }
        if (annotation instanceof Default.String) {
            return ((Default.String)annotation).value();
        }
        if (annotation instanceof Default.Boolean) {
            return ((Default.Boolean)annotation).value();
        }
        if (annotation instanceof Default.Character) {
            return Character.valueOf(((Default.Character)annotation).value());
        }
        if (annotation instanceof Default.Byte) {
            return ((Default.Byte)annotation).value();
        }
        if (annotation instanceof Default.Short) {
            return ((Default.Short)annotation).value();
        }
        if (annotation instanceof Default.Integer) {
            return ((Default.Integer)annotation).value();
        }
        if (annotation instanceof Default.Long) {
            return ((Default.Long)annotation).value();
        }
        if (annotation instanceof Default.Float) {
            return Float.valueOf(((Default.Float)annotation).value());
        }
        if (annotation instanceof Default.Double) {
            return ((Default.Double)annotation).value();
        }
        if (annotation instanceof Default.Enum) {
            return Enum.valueOf(method.getReturnType(), ((Default.Enum)annotation).value());
        }
        if (annotation instanceof Default.InstanceFactory) {
            return InstanceBuilder.ofType(((Default.InstanceFactory)annotation).value()).build().create(proxy);
        }
        return null;
    }

    private static Map<String, String> generateGettersToPropertyNames(List<PropertyDescriptor> propertyDescriptors) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getReadMethod() == null) continue;
            builder.put(descriptor.getReadMethod().getName(), descriptor.getName());
        }
        return builder.build();
    }

    private static Map<String, String> generateSettersToPropertyNames(List<PropertyDescriptor> propertyDescriptors) {
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            if (descriptor.getWriteMethod() == null) continue;
            builder.put(descriptor.getWriteMethod().getName(), descriptor.getName());
        }
        return builder.build();
    }

    static class Deserializer
    extends JsonDeserializer<PipelineOptions> {
        Deserializer() {
        }

        @Override
        public PipelineOptions deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectNode objectNode = (ObjectNode)jp.readValueAsTree();
            JsonNode rawOptionsNode = objectNode.get("options");
            HashMap<String, JsonNode> fields = Maps.newHashMap();
            if (rawOptionsNode != null && !rawOptionsNode.isNull()) {
                ObjectNode optionsNode = (ObjectNode)rawOptionsNode;
                Iterator<Map.Entry<String, JsonNode>> iterator = optionsNode.fields();
                while (iterator != null && iterator.hasNext()) {
                    Map.Entry<String, JsonNode> field = iterator.next();
                    fields.put(field.getKey(), field.getValue());
                }
            }
            PipelineOptions options = new ProxyInvocationHandler(Maps.newHashMap(), fields).as(PipelineOptions.class);
            ValueProvider.RuntimeValueProvider.setRuntimeOptions(options);
            return options;
        }
    }

    static class Serializer
    extends JsonSerializer<PipelineOptions> {
        Serializer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void serialize(PipelineOptions value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            ProxyInvocationHandler handler;
            ProxyInvocationHandler proxyInvocationHandler = handler = (ProxyInvocationHandler)Proxy.getInvocationHandler(value);
            synchronized (proxyInvocationHandler) {
                HashMap<String, BoundValue> filteredOptions = Maps.newHashMap(handler.options);
                PipelineOptionsFactory.Cache cache = PipelineOptionsFactory.CACHE.get();
                this.removeIgnoredOptions(cache, handler.knownInterfaces, filteredOptions);
                this.ensureSerializable(cache, handler.knownInterfaces, filteredOptions);
                HashMap<String, Object> serializableOptions = Maps.newHashMap(handler.jsonOptions);
                for (Map.Entry entry : filteredOptions.entrySet()) {
                    serializableOptions.put((String)entry.getKey(), ((BoundValue)entry.getValue()).getValue());
                }
                jgen.writeStartObject();
                jgen.writeFieldName("options");
                jgen.writeObject(serializableOptions);
                ArrayList<Map> serializedDisplayData = Lists.newArrayList();
                DisplayData displayData = DisplayData.from(value);
                for (DisplayData.Item item : displayData.items()) {
                    Map serializedItem = PipelineOptionsFactory.MAPPER.convertValue((Object)item, Map.class);
                    serializedDisplayData.add(serializedItem);
                }
                jgen.writeFieldName("display_data");
                jgen.writeObject(serializedDisplayData);
                jgen.writeEndObject();
            }
        }

        private void removeIgnoredOptions(PipelineOptionsFactory.Cache cache, Set<Class<? extends PipelineOptions>> interfaces, Map<String, ?> options) {
            ImmutableSet jsonIgnoreMethodNames = FluentIterable.from(ReflectHelpers.getClosureOfMethodsOnInterfaces(interfaces)).filter(PipelineOptionsFactory.AnnotationPredicates.JSON_IGNORE.forMethod).transform(Method::getName).toSet();
            for (PropertyDescriptor descriptor : cache.getPropertyDescriptors(interfaces)) {
                if (!jsonIgnoreMethodNames.contains(descriptor.getReadMethod().getName())) continue;
                options.remove(descriptor.getName());
            }
        }

        private void ensureSerializable(PipelineOptionsFactory.Cache cache, Set<Class<? extends PipelineOptions>> interfaces, Map<String, BoundValue> options) throws IOException {
            HashMap<String, Type> propertyToReturnType = Maps.newHashMap();
            for (PropertyDescriptor propertyDescriptor : cache.getPropertyDescriptors(interfaces)) {
                if (propertyDescriptor.getReadMethod() == null) continue;
                propertyToReturnType.put(propertyDescriptor.getName(), propertyDescriptor.getReadMethod().getGenericReturnType());
            }
            for (Map.Entry entry : options.entrySet()) {
                try {
                    String serializedValue = PipelineOptionsFactory.MAPPER.writeValueAsString(((BoundValue)entry.getValue()).getValue());
                    JavaType type = PipelineOptionsFactory.MAPPER.getTypeFactory().constructType((Type)propertyToReturnType.get(entry.getKey()));
                    PipelineOptionsFactory.MAPPER.readValue(serializedValue, type);
                }
                catch (Exception e) {
                    throw new IOException(String.format("Failed to serialize and deserialize property '%s' with value '%s'", entry.getKey(), ((BoundValue)entry.getValue()).getValue()), e);
                }
            }
        }
    }

    static interface UnknownPipelineOptions
    extends PipelineOptions {
    }

    @AutoValue
    static abstract class DisplayDataValue {
        DisplayDataValue() {
        }

        abstract Object getValue();

        abstract DisplayData.Type getType();

        static DisplayDataValue resolve(@Nullable Object value) {
            DisplayData.Type type = DisplayData.inferType(value);
            if (type == null) {
                value = DisplayDataValue.displayDataString(value);
                type = DisplayData.Type.STRING;
            }
            return new AutoValue_ProxyInvocationHandler_DisplayDataValue(value, type);
        }

        private static String displayDataString(@Nullable Object value) {
            if (value == null) {
                return "";
            }
            if (!value.getClass().isArray()) {
                return value.toString();
            }
            if (!value.getClass().getComponentType().isPrimitive()) {
                return Arrays.deepToString((Object[])value);
            }
            String wrapped = Arrays.deepToString(new Object[]{value});
            return wrapped.substring(1, wrapped.length() - 1);
        }
    }

    class PipelineOptionsDisplayData
    implements HasDisplayData {
        PipelineOptionsDisplayData() {
        }

        @Override
        public void populateDisplayData(DisplayData.Builder builder) {
            Set<PipelineOptionSpec> optionSpecs = PipelineOptionsReflector.getOptionSpecs(ProxyInvocationHandler.this.knownInterfaces);
            Multimap optionsMap = ProxyInvocationHandler.this.buildOptionNameToSpecMap(optionSpecs);
            for (Map.Entry option : ProxyInvocationHandler.this.options.entrySet()) {
                BoundValue boundValue = (BoundValue)option.getValue();
                if (boundValue.isDefault()) continue;
                DisplayDataValue resolved = DisplayDataValue.resolve(boundValue.getValue());
                HashSet specs = new HashSet(optionsMap.get((String)option.getKey()));
                for (PipelineOptionSpec optionSpec : specs) {
                    if (!optionSpec.shouldSerialize()) continue;
                    builder.add(DisplayData.item((String)option.getKey(), resolved.getType(), resolved.getValue()).withNamespace(optionSpec.getDefiningInterface()));
                }
            }
            for (Map.Entry jsonOption : ProxyInvocationHandler.this.jsonOptions.entrySet()) {
                if (ProxyInvocationHandler.this.options.containsKey(jsonOption.getKey())) continue;
                HashSet specs = new HashSet(optionsMap.get((String)jsonOption.getKey()));
                if (specs.isEmpty()) {
                    builder.add(DisplayData.item((String)jsonOption.getKey(), ((JsonNode)jsonOption.getValue()).toString()).withNamespace(UnknownPipelineOptions.class));
                    continue;
                }
                for (PipelineOptionSpec spec : specs) {
                    if (!spec.shouldSerialize()) continue;
                    Object value = ProxyInvocationHandler.this.getValueFromJson((String)jsonOption.getKey(), spec.getGetterMethod());
                    DisplayDataValue resolved = DisplayDataValue.resolve(value);
                    builder.add(DisplayData.item((String)jsonOption.getKey(), resolved.getType(), resolved.getValue()).withNamespace(spec.getDefiningInterface()));
                }
            }
        }
    }

    @AutoValue
    static abstract class BoundValue {
        BoundValue() {
        }

        @Nullable
        abstract Object getValue();

        abstract boolean isDefault();

        private static BoundValue of(@Nullable Object value, boolean isDefault) {
            return new AutoValue_ProxyInvocationHandler_BoundValue(value, isDefault);
        }

        static BoundValue fromExplicitOption(@Nullable Object value) {
            return BoundValue.of(value, false);
        }

        static BoundValue fromDefault(@Nullable Object value) {
            return BoundValue.of(value, true);
        }
    }
}

