/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.FieldValueGetterFactory;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.FieldValueTypeInformationFactory;
import org.apache.beam.sdk.schemas.GetterBasedSchemaProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.UserTypeCreatorFactory;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldName;
import org.apache.beam.sdk.schemas.annotations.SchemaIgnore;
import org.apache.beam.sdk.schemas.utils.AutoValueUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;

public class AutoValueSchema
extends GetterBasedSchemaProvider {
    @Override
    FieldValueGetterFactory fieldValueGetterFactory() {
        return (targetClass, schema) -> JavaBeanUtils.getGetters(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
    }

    @Override
    FieldValueTypeInformationFactory fieldValueTypeInformationFactory() {
        return (targetClass, schema) -> JavaBeanUtils.getFieldTypes(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
    }

    @Override
    UserTypeCreatorFactory schemaTypeCreatorFactory() {
        return (targetClass, schema) -> {
            Method annotated = ReflectUtils.getAnnotatedCreateMethod(targetClass);
            if (annotated != null) {
                return JavaBeanUtils.getStaticCreator(targetClass, annotated, schema, AbstractGetterTypeSupplier.INSTANCE);
            }
            SchemaUserTypeCreator creatorFactory = AutoValueUtils.getBuilderCreator(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
            if (creatorFactory != null) {
                return creatorFactory;
            }
            creatorFactory = AutoValueUtils.getConstructorCreator(targetClass, schema, AbstractGetterTypeSupplier.INSTANCE);
            if (creatorFactory == null) {
                throw new RuntimeException("Could not find a way to create AutoValue class " + targetClass);
            }
            return creatorFactory;
        };
    }

    @Override
    @Nullable
    public <T> Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
        return JavaBeanUtils.schemaFromJavaBeanClass(typeDescriptor.getRawType(), AbstractGetterTypeSupplier.INSTANCE);
    }

    @VisibleForTesting
    public static class AbstractGetterTypeSupplier
    implements FieldValueTypeSupplier {
        public static final AbstractGetterTypeSupplier INSTANCE = new AbstractGetterTypeSupplier();

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            Class targetClass = AutoValueUtils.getBaseAutoValueClass(clazz);
            return ReflectUtils.getMethods(targetClass).stream().filter(ReflectUtils::isGetter).filter(m -> Modifier.isAbstract(m.getModifiers())).filter(m -> !Modifier.isPrivate(m.getModifiers())).filter(m -> !Modifier.isProtected(m.getModifiers())).filter(m -> !m.isAnnotationPresent(SchemaIgnore.class)).map(FieldValueTypeInformation::forGetter).map(t -> {
                SchemaFieldName fieldName = t.getMethod().getAnnotation(SchemaFieldName.class);
                return fieldName == null ? t : t.withName(fieldName.value());
            }).collect(Collectors.toList());
        }
    }
}

