/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.Factory;
import org.apache.beam.sdk.schemas.Schema;

class CachingFactory<CreatedT>
implements Factory<CreatedT> {
    @Nullable
    private transient ConcurrentHashMap<Class, CreatedT> cache = null;
    private final Factory<CreatedT> innerFactory;

    public CachingFactory(Factory<CreatedT> innerFactory) {
        this.innerFactory = innerFactory;
    }

    @Override
    public CreatedT create(Class<?> clazz, Schema schema) {
        CreatedT cached;
        if (this.cache == null) {
            this.cache = new ConcurrentHashMap();
        }
        if ((cached = this.cache.get(clazz)) != null) {
            return cached;
        }
        cached = this.innerFactory.create(clazz, schema);
        this.cache.put(clazz, cached);
        return cached;
    }
}

