/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.schemas.AutoValue_FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;

@AutoValue
public abstract class FieldValueTypeInformation
implements Serializable {
    public abstract String getName();

    public abstract boolean isNullable();

    public abstract TypeDescriptor getType();

    public abstract Class getRawType();

    @Nullable
    public abstract Field getField();

    @Nullable
    public abstract Method getMethod();

    @Nullable
    public abstract FieldValueTypeInformation getElementType();

    @Nullable
    public abstract FieldValueTypeInformation getMapKeyType();

    @Nullable
    public abstract FieldValueTypeInformation getMapValueType();

    abstract Builder toBuilder();

    public static FieldValueTypeInformation forField(Field field) {
        TypeDescriptor<?> type = TypeDescriptor.of(field.getGenericType());
        return new AutoValue_FieldValueTypeInformation.Builder().setName(field.getName()).setNullable(field.isAnnotationPresent(Nullable.class)).setType(type).setRawType(type.getRawType()).setField(field).setElementType(FieldValueTypeInformation.getArrayComponentType(field)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(field)).setMapValueType(FieldValueTypeInformation.getMapValueType(field)).build();
    }

    public static FieldValueTypeInformation forGetter(Method method) {
        String name;
        if (method.getName().startsWith("get")) {
            name = ReflectUtils.stripPrefix(method.getName(), "get");
        } else if (method.getName().startsWith("is")) {
            name = ReflectUtils.stripPrefix(method.getName(), "is");
        } else {
            throw new RuntimeException("Getter has wrong prefix " + method.getName());
        }
        TypeDescriptor<?> type = TypeDescriptor.of(method.getGenericReturnType());
        boolean nullable = method.isAnnotationPresent(Nullable.class);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(name).setNullable(nullable).setType(type).setRawType(type.getRawType()).setMethod(method).setElementType(FieldValueTypeInformation.getArrayComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).build();
    }

    public static FieldValueTypeInformation forSetter(Method method) {
        if (!method.getName().startsWith("set")) {
            throw new RuntimeException("Setter has wrong prefix " + method.getName());
        }
        String name = ReflectUtils.stripPrefix(method.getName(), "set");
        if (method.getParameterCount() != 1) {
            throw new RuntimeException("Setter methods should take a single argument.");
        }
        TypeDescriptor<?> type = TypeDescriptor.of(method.getGenericParameterTypes()[0]);
        boolean nullable = Arrays.stream(method.getParameterAnnotations()[0]).anyMatch(Nullable.class::isInstance);
        return new AutoValue_FieldValueTypeInformation.Builder().setName(name).setNullable(nullable).setType(type).setRawType(type.getRawType()).setMethod(method).setElementType(FieldValueTypeInformation.getArrayComponentType(type)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(type)).setMapValueType(FieldValueTypeInformation.getMapValueType(type)).build();
    }

    public FieldValueTypeInformation withName(String name) {
        return this.toBuilder().setName(name).build();
    }

    private static FieldValueTypeInformation getArrayComponentType(Field field) {
        return FieldValueTypeInformation.getArrayComponentType(TypeDescriptor.of(field.getGenericType()));
    }

    @Nullable
    private static FieldValueTypeInformation getArrayComponentType(TypeDescriptor valueType) {
        TypeDescriptor<?> componentType = null;
        if (valueType.isArray()) {
            Type component = valueType.getComponentType().getType();
            if (!component.equals(Byte.TYPE)) {
                componentType = TypeDescriptor.of(component);
            }
        } else if (valueType.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
            TypeDescriptor<Collection> collection = valueType.getSupertype(Collection.class);
            if (collection.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)collection.getType();
                Type[] params = ptype.getActualTypeArguments();
                Preconditions.checkArgument(params.length == 1);
                componentType = TypeDescriptor.of(params[0]);
            } else {
                throw new RuntimeException("Collection parameter is not parameterized!");
            }
        }
        if (componentType == null) {
            return null;
        }
        return new AutoValue_FieldValueTypeInformation.Builder().setName("").setNullable(false).setType(componentType).setRawType(componentType.getRawType()).setElementType(FieldValueTypeInformation.getArrayComponentType(componentType)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(componentType)).setMapValueType(FieldValueTypeInformation.getMapValueType(componentType)).build();
    }

    @Nullable
    private static FieldValueTypeInformation getMapKeyType(Field field) {
        return FieldValueTypeInformation.getMapKeyType(TypeDescriptor.of(field.getGenericType()));
    }

    @Nullable
    private static FieldValueTypeInformation getMapKeyType(TypeDescriptor<?> typeDescriptor) {
        return FieldValueTypeInformation.getMapType(typeDescriptor, 0);
    }

    @Nullable
    private static FieldValueTypeInformation getMapValueType(Field field) {
        return FieldValueTypeInformation.getMapType(TypeDescriptor.of(field.getGenericType()), 1);
    }

    @Nullable
    private static FieldValueTypeInformation getMapValueType(TypeDescriptor typeDescriptor) {
        return FieldValueTypeInformation.getMapType(typeDescriptor, 1);
    }

    @Nullable
    private static FieldValueTypeInformation getMapType(TypeDescriptor valueType, int index) {
        TypeDescriptor<?> mapType = null;
        if (valueType.isSubtypeOf(TypeDescriptor.of(Map.class))) {
            TypeDescriptor<Map> map = valueType.getSupertype(Map.class);
            if (map.getType() instanceof ParameterizedType) {
                ParameterizedType ptype = (ParameterizedType)map.getType();
                Type[] params = ptype.getActualTypeArguments();
                mapType = TypeDescriptor.of(params[index]);
            } else {
                throw new RuntimeException("Map type is not parameterized! " + map);
            }
        }
        if (mapType == null) {
            return null;
        }
        return new AutoValue_FieldValueTypeInformation.Builder().setName("").setNullable(false).setType(mapType).setRawType(mapType.getRawType()).setElementType(FieldValueTypeInformation.getArrayComponentType(mapType)).setMapKeyType(FieldValueTypeInformation.getMapKeyType(mapType)).setMapValueType(FieldValueTypeInformation.getMapValueType(mapType)).build();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        public abstract Builder setName(String var1);

        public abstract Builder setNullable(boolean var1);

        public abstract Builder setType(TypeDescriptor var1);

        public abstract Builder setRawType(Class var1);

        public abstract Builder setField(@Nullable Field var1);

        public abstract Builder setMethod(@Nullable Method var1);

        public abstract Builder setElementType(@Nullable FieldValueTypeInformation var1);

        public abstract Builder setMapKeyType(@Nullable FieldValueTypeInformation var1);

        public abstract Builder setMapValueType(@Nullable FieldValueTypeInformation var1);

        abstract FieldValueTypeInformation build();
    }
}

