/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.CachingFactory;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueGetterFactory;
import org.apache.beam.sdk.schemas.FieldValueTypeInformationFactory;
import org.apache.beam.sdk.schemas.FromRowUsingCreator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.UserTypeCreatorFactory;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public abstract class GetterBasedSchemaProvider
implements SchemaProvider {
    abstract FieldValueGetterFactory fieldValueGetterFactory();

    abstract FieldValueTypeInformationFactory fieldValueTypeInformationFactory();

    abstract UserTypeCreatorFactory schemaTypeCreatorFactory();

    @Override
    public <T> SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
        Schema schema = this.schemaFor(typeDescriptor);
        CachingFactory<List<FieldValueGetter>> getterFactory = new CachingFactory<List<FieldValueGetter>>(this.fieldValueGetterFactory());
        return o -> Row.withSchema(schema).withFieldValueGetters(getterFactory, o).build();
    }

    @Override
    public <T> SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
        Class clazz = (Class)typeDescriptor.getType();
        return new FromRowUsingCreator(clazz, this.schemaTypeCreatorFactory(), this.fieldValueTypeInformationFactory());
    }
}

