/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.parser;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_sdks_java_core.org.antlr.v4.runtime.CharStreams;
import org.apache.beam.repackaged.beam_sdks_java_core.org.antlr.v4.runtime.CodePointCharStream;
import org.apache.beam.repackaged.beam_sdks_java_core.org.antlr.v4.runtime.CommonTokenStream;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.parser.generated.FieldSpecifierNotationBaseVisitor;
import org.apache.beam.sdk.schemas.parser.generated.FieldSpecifierNotationLexer;
import org.apache.beam.sdk.schemas.parser.generated.FieldSpecifierNotationParser;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;

public class FieldAccessDescriptorParser {
    public static FieldAccessDescriptor parse(String expr) {
        CodePointCharStream charStream = CharStreams.fromString(expr);
        FieldSpecifierNotationLexer lexer = new FieldSpecifierNotationLexer(charStream);
        CommonTokenStream tokens = new CommonTokenStream(lexer);
        FieldSpecifierNotationParser parser = new FieldSpecifierNotationParser(tokens);
        return (FieldAccessDescriptor)new BuildFieldAccessDescriptor().visit(parser.dotExpression());
    }

    private static class QualifierVisitor
    extends FieldSpecifierNotationBaseVisitor<FieldAccessDescriptor> {
        private final List<FieldAccessDescriptor.FieldDescriptor.Qualifier> qualifiers = Lists.newArrayList();

        private QualifierVisitor() {
        }

        @Override
        @Nullable
        public FieldAccessDescriptor visitArrayQualifierList(FieldSpecifierNotationParser.ArrayQualifierListContext ctx) {
            this.qualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.ListQualifier.ALL));
            ctx.qualifierList().forEach(subList -> subList.accept(this));
            return null;
        }

        @Override
        @Nullable
        public FieldAccessDescriptor visitMapQualifierList(FieldSpecifierNotationParser.MapQualifierListContext ctx) {
            this.qualifiers.add(FieldAccessDescriptor.FieldDescriptor.Qualifier.of(FieldAccessDescriptor.FieldDescriptor.MapQualifier.ALL));
            ctx.qualifierList().forEach(subList -> subList.accept(this));
            return null;
        }

        public List<FieldAccessDescriptor.FieldDescriptor.Qualifier> getQualifiers() {
            return this.qualifiers;
        }
    }

    private static class BuildFieldAccessDescriptor
    extends FieldSpecifierNotationBaseVisitor<FieldAccessDescriptor> {
        private BuildFieldAccessDescriptor() {
        }

        @Override
        public FieldAccessDescriptor visitFieldSpecifier(FieldSpecifierNotationParser.FieldSpecifierContext ctx) {
            return ctx.dotExpression().accept(this);
        }

        @Override
        public FieldAccessDescriptor visitDotExpression(FieldSpecifierNotationParser.DotExpressionContext ctx) {
            List components = ctx.dotExpressionComponent().stream().map(dotE -> dotE.accept(this)).collect(Collectors.toList());
            Preconditions.checkArgument(!components.isEmpty());
            FieldAccessDescriptor fieldAccessDescriptor = (FieldAccessDescriptor)components.get(components.size() - 1);
            for (int i = components.size() - 2; i >= 0; --i) {
                FieldAccessDescriptor component = (FieldAccessDescriptor)components.get(i);
                if (component.getAllFields()) {
                    throw new IllegalArgumentException("We currently only support wildcards at terminal parts of selectors. 'x.*' is allowed, but x.*.y is not currently allowed.");
                }
                FieldAccessDescriptor.FieldDescriptor fieldAccessed = (FieldAccessDescriptor.FieldDescriptor)component.getFieldsAccessed().stream().findFirst().orElseThrow(IllegalArgumentException::new);
                fieldAccessDescriptor = FieldAccessDescriptor.withFields(new FieldAccessDescriptor.FieldDescriptor[0]).withNestedField(fieldAccessed, fieldAccessDescriptor);
            }
            return fieldAccessDescriptor;
        }

        @Override
        public FieldAccessDescriptor visitQualifyComponent(FieldSpecifierNotationParser.QualifyComponentContext ctx) {
            return ctx.qualifiedComponent().accept(this);
        }

        @Override
        public FieldAccessDescriptor visitSimpleIdentifier(FieldSpecifierNotationParser.SimpleIdentifierContext ctx) {
            FieldAccessDescriptor.FieldDescriptor field = FieldAccessDescriptor.FieldDescriptor.builder().setFieldName(ctx.IDENTIFIER().getText()).build();
            return FieldAccessDescriptor.withFields(field);
        }

        @Override
        public FieldAccessDescriptor visitWildcard(FieldSpecifierNotationParser.WildcardContext ctx) {
            return FieldAccessDescriptor.withAllFields();
        }

        @Override
        public FieldAccessDescriptor visitQualifiedComponent(FieldSpecifierNotationParser.QualifiedComponentContext ctx) {
            QualifierVisitor qualifierVisitor = new QualifierVisitor();
            ctx.qualifierList().accept(qualifierVisitor);
            FieldAccessDescriptor.FieldDescriptor field = FieldAccessDescriptor.FieldDescriptor.builder().setFieldName(ctx.IDENTIFIER().getText()).setQualifiers(qualifierVisitor.getQualifiers()).build();
            return FieldAccessDescriptor.withFields(field);
        }
    }
}

