/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Cast;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Cast_CompatibilityError;
import org.apache.beam.sdk.schemas.utils.SchemaZipFold;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Maps;

@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoValue
public abstract class Cast<T>
extends PTransform<PCollection<T>, PCollection<Row>> {
    public abstract Schema outputSchema();

    public abstract Validator validator();

    public static <T> Cast<T> of(Schema outputSchema, Validator validator) {
        return new AutoValue_Cast(outputSchema, validator);
    }

    public static <T> Cast<T> widening(Schema outputSchema) {
        return new AutoValue_Cast(outputSchema, Widening.of());
    }

    public static <T> Cast<T> narrowing(Schema outputSchema) {
        return new AutoValue_Cast(outputSchema, Narrowing.of());
    }

    public static boolean isIntegral(Schema.TypeName type) {
        return type == Schema.TypeName.BYTE || type == Schema.TypeName.INT16 || type == Schema.TypeName.INT32 || type == Schema.TypeName.INT64;
    }

    public static boolean isDecimal(Schema.TypeName type) {
        return type == Schema.TypeName.FLOAT || type == Schema.TypeName.DOUBLE || type == Schema.TypeName.DECIMAL;
    }

    public void verifyCompatibility(Schema inputSchema) {
        List<CompatibilityError> errors = this.validator().apply(inputSchema, this.outputSchema());
        if (!errors.isEmpty()) {
            String reason = errors.stream().map(x -> Joiner.on('.').join(x.path()) + ": " + x.message()).collect(Collectors.joining("\n\t"));
            throw new IllegalArgumentException("Cast isn't compatible using " + this.validator() + ":\n\t" + reason);
        }
    }

    @Override
    public PCollection<Row> expand(PCollection<T> input) {
        final Schema inputSchema = input.getSchema();
        this.verifyCompatibility(inputSchema);
        return ((PCollection)input.apply(ParDo.of(new DoFn<T, Row>(){
            @DoFn.FieldAccess(value="filterFields")
            final FieldAccessDescriptor fieldAccessDescriptor = FieldAccessDescriptor.withAllFields();

            @DoFn.ProcessElement
            public void process(@DoFn.FieldAccess(value="filterFields") @DoFn.Element Row input, DoFn.OutputReceiver<Row> r) {
                Row output = Cast.castRow(input, inputSchema, Cast.this.outputSchema());
                r.output(output);
            }
        }))).setRowSchema(this.outputSchema());
    }

    public static Row castRow(Row input, Schema inputSchema, Schema outputSchema) {
        if (input == null) {
            return null;
        }
        Row.Builder output = Row.withSchema(outputSchema);
        for (int i = 0; i < outputSchema.getFieldCount(); ++i) {
            Schema.Field outputField = outputSchema.getField(i);
            int fromFieldIdx = inputSchema.indexOf(outputField.getName());
            Schema.Field inputField = inputSchema.getField(fromFieldIdx);
            Object inputValue = input.getValue(fromFieldIdx);
            Object outputValue = Cast.castValue(inputValue, inputField.getType(), outputField.getType());
            output.addValue(outputValue);
        }
        return output.build();
    }

    public static Number castNumber(Number value, Schema.TypeName input, Schema.TypeName output) {
        if (!input.isNumericType()) {
            throw new RuntimeException("Can't cast non-numeric types: " + (Object)((Object)input));
        }
        if (!output.isNumericType()) {
            throw new RuntimeException("Can't cast numbers to non-numeric type: " + (Object)((Object)output));
        }
        if (value == null) {
            return null;
        }
        if (input == output) {
            return value;
        }
        switch (output) {
            case BYTE: {
                return value.byteValue();
            }
            case INT16: {
                return value.shortValue();
            }
            case INT32: {
                return value.intValue();
            }
            case INT64: {
                return value.longValue();
            }
            case FLOAT: {
                return Float.valueOf(value.floatValue());
            }
            case DOUBLE: {
                return value.doubleValue();
            }
            case DECIMAL: {
                switch (input) {
                    case BYTE: 
                    case INT16: 
                    case INT32: {
                        return new BigDecimal(value.intValue());
                    }
                    case INT64: {
                        return new BigDecimal(value.longValue());
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new BigDecimal(value.doubleValue());
                    }
                }
                throw new AssertionError((Object)("Unexpected numeric type: " + (Object)((Object)output)));
            }
        }
        throw new AssertionError((Object)("Unexpected numeric type: " + (Object)((Object)output)));
    }

    public static Object castValue(Object inputValue, Schema.FieldType input, Schema.FieldType output) {
        Schema.TypeName inputType = input.getTypeName();
        Schema.TypeName outputType = output.getTypeName();
        if (inputValue == null) {
            return null;
        }
        switch (inputType) {
            case ROW: {
                return Cast.castRow((Row)inputValue, input.getRowSchema(), output.getRowSchema());
            }
            case ARRAY: {
                List inputValues = (List)inputValue;
                ArrayList<Object> outputValues = new ArrayList<Object>(inputValues.size());
                for (Object elem : inputValues) {
                    outputValues.add(Cast.castValue(elem, input.getCollectionElementType(), output.getCollectionElementType()));
                }
                return outputValues;
            }
            case MAP: {
                Map inputMap = (Map)inputValue;
                HashMap<Object, Object> outputMap = Maps.newHashMapWithExpectedSize(inputMap.size());
                for (Map.Entry entry : inputMap.entrySet()) {
                    Object outputKey = Cast.castValue(entry.getKey(), input.getMapKeyType(), output.getMapKeyType());
                    Object outputValue = Cast.castValue(entry.getValue(), input.getMapValueType(), output.getMapValueType());
                    outputMap.put(outputKey, outputValue);
                }
                return outputMap;
            }
        }
        if (inputType.equals((Object)outputType)) {
            return inputValue;
        }
        if (inputType.isNumericType()) {
            return Cast.castNumber((Number)inputValue, inputType, outputType);
        }
        throw new IllegalArgumentException("input should be array, map, numeric or row");
    }

    public static class Narrowing
    implements Validator {
        private final Fold fold = new Fold();

        public static Narrowing of() {
            return new Narrowing();
        }

        public String toString() {
            return "Cast.Narrowing";
        }

        @Override
        public List<CompatibilityError> apply(Schema input, Schema output) {
            return (List)this.fold.apply(input, output);
        }

        private static class Fold
        extends SchemaZipFold<List<CompatibilityError>> {
            private Fold() {
            }

            @Override
            public List<CompatibilityError> accumulate(List<CompatibilityError> left, List<CompatibilityError> right) {
                return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(left)).addAll(right)).build();
            }

            @Override
            public List<CompatibilityError> accept(SchemaZipFold.Context context, Optional<Schema.Field> left, Optional<Schema.Field> right) {
                if (!left.isPresent() && right.isPresent()) {
                    return Collections.singletonList(CompatibilityError.create(context.path(), "Field is missing in output schema"));
                }
                return Collections.emptyList();
            }

            @Override
            public List<CompatibilityError> accept(SchemaZipFold.Context context, Schema.FieldType input, Schema.FieldType output) {
                Schema.TypeName inputType = input.getTypeName();
                Schema.TypeName outputType = output.getTypeName();
                boolean supertype = outputType.isSupertypeOf(inputType);
                boolean subtype = outputType.isSubtypeOf(inputType);
                if (Cast.isDecimal(inputType) && Cast.isIntegral(outputType)) {
                    return Collections.emptyList();
                }
                if (!supertype && !subtype) {
                    return Collections.singletonList(CompatibilityError.create(context.path(), "Can't cast '" + (Object)((Object)inputType) + "' to '" + (Object)((Object)outputType) + "'"));
                }
                return Collections.emptyList();
            }
        }
    }

    public static class Widening
    implements Validator {
        private final Fold fold = new Fold();

        public static Widening of() {
            return new Widening();
        }

        public String toString() {
            return "Cast.Widening";
        }

        @Override
        public List<CompatibilityError> apply(Schema input, Schema output) {
            return (List)this.fold.apply(input, output);
        }

        private static class Fold
        extends SchemaZipFold<List<CompatibilityError>> {
            private Fold() {
            }

            @Override
            public List<CompatibilityError> accumulate(List<CompatibilityError> left, List<CompatibilityError> right) {
                return ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(left)).addAll(right)).build();
            }

            @Override
            public List<CompatibilityError> accept(SchemaZipFold.Context context, Optional<Schema.Field> left, Optional<Schema.Field> right) {
                if (!left.isPresent() && !right.isPresent()) {
                    return Collections.emptyList();
                }
                if (left.isPresent() && !right.isPresent()) {
                    return Collections.emptyList();
                }
                if (!left.isPresent() && right.isPresent()) {
                    return Collections.singletonList(CompatibilityError.create(context.path(), "Field is missing in output schema"));
                }
                if (left.get().getType().getNullable().booleanValue() && !right.get().getType().getNullable().booleanValue()) {
                    return Collections.singletonList(CompatibilityError.create(context.path(), "Can't cast nullable field to non-nullable field"));
                }
                return Collections.emptyList();
            }

            @Override
            public List<CompatibilityError> accept(SchemaZipFold.Context context, Schema.FieldType input, Schema.FieldType output) {
                Schema.TypeName inputType = input.getTypeName();
                Schema.TypeName outputType = output.getTypeName();
                boolean supertype = outputType.isSupertypeOf(inputType);
                if (Cast.isIntegral(inputType) && Cast.isDecimal(outputType)) {
                    return Collections.emptyList();
                }
                if (!supertype) {
                    return Collections.singletonList(CompatibilityError.create(context.path(), "Can't cast '" + (Object)((Object)inputType) + "' to '" + (Object)((Object)outputType) + "'"));
                }
                return Collections.emptyList();
            }
        }
    }

    public static interface Validator
    extends Serializable {
        public List<CompatibilityError> apply(Schema var1, Schema var2);
    }

    @AutoValue
    public static abstract class CompatibilityError
    implements Serializable {
        public abstract List<String> path();

        public abstract String message();

        public static CompatibilityError create(List<String> path, String message) {
            return new AutoValue_Cast_CompatibilityError(path, message);
        }
    }
}

