/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Convert {
    public static <InputT> PTransform<PCollection<InputT>, PCollection<Row>> toRows() {
        return Convert.to(Row.class);
    }

    public static <OutputT> PTransform<PCollection<Row>, PCollection<OutputT>> fromRows(Class<OutputT> clazz) {
        return Convert.to(clazz);
    }

    public static <OutputT> PTransform<PCollection<Row>, PCollection<OutputT>> fromRows(TypeDescriptor<OutputT> typeDescriptor) {
        return Convert.to(typeDescriptor);
    }

    public static <InputT, OutputT> PTransform<PCollection<InputT>, PCollection<OutputT>> to(Class<OutputT> clazz) {
        return Convert.to(TypeDescriptor.of(clazz));
    }

    public static <InputT, OutputT> PTransform<PCollection<InputT>, PCollection<OutputT>> to(TypeDescriptor<OutputT> typeDescriptor) {
        return new ConvertTransform(typeDescriptor);
    }

    private static class ConvertTransform<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        TypeDescriptor<OutputT> outputTypeDescriptor;

        ConvertTransform(TypeDescriptor<OutputT> outputTypeDescriptor) {
            this.outputTypeDescriptor = outputTypeDescriptor;
        }

        @Override
        public PCollection<OutputT> expand(PCollection<InputT> input) {
            SchemaCoder<Object> outputSchemaCoder;
            if (!input.hasSchema()) {
                throw new RuntimeException("Convert requires a schema on the input.");
            }
            boolean toRow = this.outputTypeDescriptor.equals(TypeDescriptor.of(Row.class));
            if (toRow) {
                outputSchemaCoder = SchemaCoder.of(input.getSchema(), SerializableFunctions.identity(), SerializableFunctions.identity());
            } else {
                SchemaRegistry registry = input.getPipeline().getSchemaRegistry();
                try {
                    outputSchemaCoder = SchemaCoder.of(registry.getSchema(this.outputTypeDescriptor), registry.getToRowFunction(this.outputTypeDescriptor), registry.getFromRowFunction(this.outputTypeDescriptor));
                    if (!outputSchemaCoder.getSchema().assignableToIgnoreNullable(input.getSchema())) {
                        throw new RuntimeException("Cannot convert between types that don't have equivalent schemas. input schema: " + input.getSchema() + " output schema: " + outputSchemaCoder.getSchema());
                    }
                }
                catch (NoSuchSchemaException e) {
                    throw new RuntimeException("No schema registered for " + this.outputTypeDescriptor);
                }
            }
            return ((PCollection)input.apply(ParDo.of(new DoFn<InputT, OutputT>(){

                @DoFn.ProcessElement
                public void processElement(@DoFn.Element Row row, DoFn.OutputReceiver<OutputT> o) {
                    o.output(outputSchemaCoder.getFromRowFunction().apply(row));
                }
            }))).setSchema(outputSchemaCoder.getSchema(), outputSchemaCoder.getToRowFunction(), outputSchemaCoder.getFromRowFunction());
        }
    }
}

